<?php

namespace QuizPress\Mail;

use QuizPress\Helper;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class MagicLink{

    public static function init(){
        $self = new self();
        add_action('quizpress/after_create_magic_link', [$self, 'after_create_magic_link'], 10, 2);
    }

    public function after_create_magic_link($link, $user){
        error_log('QuizPress MagicLink triggered: ' . $link);
        error_log('User email: ' . $user->user_email);

        $to = $user->user_email;
        $subject = esc_html__('Your Magic Login Link', 'quizpress');
        if(! empty($link)){

            $args = [
                'magic_link' => $link,
                'user' => $user
            ];

            ob_start();
            Helper::get_template_part( 'email/magic-link', '', $args );
            $message = ob_get_clean();
            error_log($message);
            $headers = [ 'Content-Type: text/html; charset=UTF-8' ];

            wp_mail( $to, $subject, $message, $headers );
        }
    }
}