<?php
namespace QuizPress;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Miscellaneous {
	public static function init() {
		$self = new self();
		add_action( 'rest_delete_quizpress_quiz', array( $self, 'delete_quiz_data' ) );
	}

	public function delete_quiz_data( $post ) {
		global $wpdb;
		$quiz_id = $post->ID;
		wp_delete_post( $quiz_id );
		$wpdb->delete( $wpdb->prefix . 'quizpress_attempts', array( 'quiz_id' => $quiz_id ), array( '%d' ) );
		$wpdb->delete( $wpdb->prefix . 'quizpress_attempt_answers', array( 'quiz_id' => $quiz_id ), array( '%d' ) );
	}

}
