<?php
namespace QuizPress\Shortcode;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class QuizpressQuiz {
    private $quiz_id = null;
    public static function init() {
        $self = new self();
        add_shortcode( 'quizpress_quiz', array($self, 'render_quiz') );
	}

    public function render_quiz( $attr ) {
        // Parse shortcode attributes
        $attributes   = shortcode_atts( [
            'quiz_id' => ''
        ], $attr );

        $this->quiz_id = intval( $attributes['quiz_id'] ?? 0 );

        if ( ! $this->quiz_id ) {
            return '';
        }

        // Fetch post
        $post = get_post( $this->quiz_id );
        if ( ! $post || 'publish' !== $post->post_status ) {
            return '';
        }

        // Meta data
        $image_id    = intval( get_post_meta( $this->quiz_id, '_thumbnail_id', true ) );
        $hint_text   = get_post_meta( $this->quiz_id, 'quizpress_quiz_hint_text', true ) ?: '';
        $type        = get_post_meta( $this->quiz_id, 'quizpress_quiz_product_type', true );
        $product_id  = intval( get_post_meta( $this->quiz_id, 'quizpress_quiz_product_id', true ) );
        $linked_status  = get_post_meta( $product_id, '_quizpress_product', true );

        // Scripts
        $this->enqueue_scripts();

        ob_start();
        ?>

        <div class="quizpressFrontendWrap" id="quizpressFrontendWrap" data-id="<?php echo esc_attr( $this->quiz_id ); ?>">
            <div class="quizpressFrontend">

                <?php if ( $image_id ) : ?>
                    <div class="quizpressFrontend__image">
                        <img src="<?php echo esc_url( wp_get_attachment_url( $image_id ) ); ?>" alt="">
                    </div>
                <?php endif; ?>

                <h3 class="quizpressFrontend__title"><?php echo esc_html( $post->post_title ); ?></h3>

                <?php if ( ! empty( $post->post_content ) ) : ?>
                    <div class="quizpressFrontend__description">
                        <?php echo wp_kses_post( $post->post_content ); ?>
                    </div>
                <?php endif; ?>

                <?php if ( $hint_text ) : ?>
                    <div class="quizpressFrontend__hint-text">
                        <span class="quizpressFrontend__hint-text-title">
                            <?php esc_html_e( 'Quiz Hint:', 'quizpress' ); ?>
                        </span>
                        <p class="quizpressFrontend__hint-text-description">
                            <?php echo wp_kses_post( $hint_text ); ?>
                        </p>
                    </div>
                <?php endif; ?>

                <?php
                // Restrict paid quiz until WooCommerce purchase is completed
                $has_access = true;

                if ( 'paid' === $type && 'yes' === $linked_status && ! empty( $product_id ) ) {
                    $has_access = \QuizPressWoocommerce\Helper::quizpress_user_has_completed_order( get_current_user_id(), $product_id );
                }
                ?>

                <?php if ( ! $has_access && 'yes' === $linked_status ) : ?>
                    <?php \QuizPress\Helper::get_template( 'integrations/woocommerce.php', [
                        'product_id' => $product_id
                    ] ); ?>
                <?php else : ?>
                    <div class="quizpressFrontend__quiz" id="quizpressFrontend__quiz"></div>
                <?php endif; ?>

            </div>
        </div>

        <?php
        return ob_get_clean();
    }

    public function enqueue_scripts(){
        wp_enqueue_style('quizpress-frontend-icon');
        wp_enqueue_style('quizpress-frontend-style');
        wp_enqueue_script('quizpress-frontend-scripts');
        add_filter('quizpress/assets/fronted_scripts_data', function($data) {
            $settings = \QuizPress\Admin\Settings\Base::get_saved_data();
            $data['_quiz_settings'] = [
                // settings will be added here
                'public_text_area_height' => $settings['quizpress_public_textarea_height'],
                'is_disable_store_ip' => $settings['is_disable_store_ip_address']
            ];
            return $data;
        });
    }
}