<?php

namespace QuizPress\Mpdf\Tag;

use QuizPress\Mpdf\Strict;

use QuizPress\Mpdf\Cache;
use QuizPress\Mpdf\Color\ColorConverter;
use QuizPress\Mpdf\CssManager;
use QuizPress\Mpdf\Form;
use QuizPress\Mpdf\Image\ImageProcessor;
use QuizPress\Mpdf\Language\LanguageToFontInterface;
use QuizPress\Mpdf\Mpdf;
use QuizPress\Mpdf\Otl;
use QuizPress\Mpdf\SizeConverter;
use QuizPress\Mpdf\TableOfContents;

abstract class Tag
{

	use Strict;

	/**
	 * @var \QuizPress\Mpdf\Mpdf
	 */
	protected $mpdf;

	/**
	 * @var \QuizPress\Mpdf\Cache
	 */
	protected $cache;

	/**
	 * @var \QuizPress\Mpdf\CssManager
	 */
	protected $cssManager;

	/**
	 * @var \QuizPress\Mpdf\Form
	 */
	protected $form;

	/**
	 * @var \QuizPress\Mpdf\Otl
	 */
	protected $otl;

	/**
	 * @var \QuizPress\Mpdf\TableOfContents
	 */
	protected $tableOfContents;

	/**
	 * @var \QuizPress\Mpdf\SizeConverter
	 */
	protected $sizeConverter;

	/**
	 * @var \QuizPress\Mpdf\Color\ColorConverter
	 */
	protected $colorConverter;

	/**
	 * @var \QuizPress\Mpdf\Image\ImageProcessor
	 */
	protected $imageProcessor;

	/**
	 * @var \QuizPress\Mpdf\Language\LanguageToFontInterface
	 */
	protected $languageToFont;

	const ALIGN = [
		'left' => 'L',
		'center' => 'C',
		'right' => 'R',
		'top' => 'T',
		'text-top' => 'TT',
		'middle' => 'M',
		'baseline' => 'BS',
		'bottom' => 'B',
		'text-bottom' => 'TB',
		'justify' => 'J'
	];

	public function __construct(
		Mpdf $mpdf,
		Cache $cache,
		CssManager $cssManager,
		Form $form,
		Otl $otl,
		TableOfContents $tableOfContents,
		SizeConverter $sizeConverter,
		ColorConverter $colorConverter,
		ImageProcessor $imageProcessor,
		LanguageToFontInterface $languageToFont
	) {

		$this->mpdf = $mpdf;
		$this->cache = $cache;
		$this->cssManager = $cssManager;
		$this->form = $form;
		$this->otl = $otl;
		$this->tableOfContents = $tableOfContents;
		$this->sizeConverter = $sizeConverter;
		$this->colorConverter = $colorConverter;
		$this->imageProcessor = $imageProcessor;
		$this->languageToFont = $languageToFont;
	}

	public function getTagName()
	{
		$tag = get_class($this);
		return strtoupper(str_replace('QuizPress\Mpdf\Tag\\', '', $tag));
	}

	protected function getAlign($property)
	{
		$property = strtolower($property);
		return array_key_exists($property, self::ALIGN) ? self::ALIGN[$property] : '';
	}

	abstract public function open($attr, &$ahtml, &$ihtml);

	abstract public function close(&$ahtml, &$ihtml);

}
