<?php
/*
 * Plugin Name: QuizPress (Premium)
 * Plugin URI:		https://quizpress.pro
 * Description:		Modern Quiz, Survey, Poll & Exam Solution
 * Version:			1.2.0
 * Update URI: https://api.freemius.com
 * Author:			Kodezen LLC
 * Author URI:		http://academylms.net
 * License:			GPL-3.0+
 * License URI:		http://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain:		quizpress
 * Domain Path:		/languages
 * 
 * @fs_premium_only /addons, /library/deps/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

final class QuizPress {

	private function __construct() {
		$this->define_constants();
		$this->set_global_settings();
		$this->load_dependency();
		register_activation_hook( __FILE__, [ $this, 'activate' ] );
		register_deactivation_hook( __FILE__, [ $this, 'deactivate' ] );
		add_action( 'plugins_loaded', [ $this, 'init_plugin' ] );
	}

	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole plugins.
		 */
		define( 'QUIZPRESS_VERSION', '1.2.0' );
		define( 'QUIZPRESS_DB_VERSION', '1.0' );
		define( 'QUIZPRESS_SETTINGS_NAME', 'quizpress_settings' );
		define( 'QUIZPRESS_ADDONS_SETTINGS_NAME', 'quizpress_addons_settings' );
		define( 'QUIZPRESS_PLUGIN_FILE', __FILE__ );
		define( 'QUIZPRESS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'QUIZPRESS_PLUGIN_SLUG', 'quizpress' );
		define( 'QUIZPRESS_PLUGIN_ROOT_URI', plugins_url( '/', __FILE__ ) );
		define( 'QUIZPRESS_ADDONS_DIR_PATH', plugin_dir_path( __FILE__ ) . 'addons/' );
		define( 'QUIZPRESS_ROOT_DIR_PATH', plugin_dir_path( __FILE__ ) );
		define( 'QUIZPRESS_INCLUDES_DIR_PATH', QUIZPRESS_ROOT_DIR_PATH . 'includes/' );
		define( 'QUIZPRESS_ASSETS_DIR_PATH', QUIZPRESS_ROOT_DIR_PATH . 'assets/' );
		define( 'QUIZPRESS_ASSETS_URI', QUIZPRESS_PLUGIN_ROOT_URI . 'assets/' );
		define( 'QUIZPRESS_TEMPLATE_DEBUG_MODE', false );
	}

	public function set_global_settings(): void {
		$GLOBALS['quizpress_settings'] = json_decode( get_option( QUIZPRESS_SETTINGS_NAME, '{}' ) );
		$GLOBALS['quizpress_addons'] = json_decode( get_option( QUIZPRESS_ADDONS_SETTINGS_NAME, '[]' ) );
	}

	/**
	 * Initialize the plugin
	 *
	 * @return void
	 */
	public function init_plugin() {
		// Init action.
		do_action( 'quizpress_before_init' );
		$this->dispatch_hooks();
		$this->load_addons();
		do_action( 'quizpress_after_init' );
	}

	public function dispatch_hooks() {
		QuizPress\Database::init();
		QuizPress\PermalinkRewrite::init();
		QuizPress\API::init();
		QuizPress\Ajax::init();
		QuizPress\Assets::init();
		QuizPress\Miscellaneous::init();
		QuizPress\Migration::init();
		QuizPress\Shortcode::init();
		QuizPress\Mail::init();
		if ( is_admin() ) {
			QuizPress\Admin::init();
		} else {
			QuizPress\Frontend::init();
		}
	}

	public function load_dependency() {
		if(file_exists(QUIZPRESS_ROOT_DIR_PATH . 'library/deps/autoload.php')){
			require_once QUIZPRESS_ROOT_DIR_PATH . 'library/deps/autoload.php';
		}
		require_once QUIZPRESS_INCLUDES_DIR_PATH . 'autoload.php';
	}

	public function activate() {
		QuizPress\Installer::init();
	}

	public function load_addons() {
		\QuizPress\Addons::init();
	}

	public function deactivate() {
	}
}

/**
 * Initializes the main plugin
 *
 * @return \QuizPress
 */
function QuizPress_Start() {
	return QuizPress::init();
}

// Plugin Start
QuizPress_Start();
