import { createPortal } from '@wordpress/element';
import { createRoot } from 'react-dom/client';
import { Provider } from 'react-redux';
import { BrowserRouter as Router } from 'react-router-dom';
import store from './redux/store';
import BackendDashboard from '@QPContainers/BackendDashboard';
import AdminMenu from '@QPContainers/BackendDashboard/AdminMenu';
import { ChakraProvider } from '@chakra-ui/react';
import { theme } from '../assets/scss/chakra/theme';

import './../assets/scss/backend.scss';

document.addEventListener( 'DOMContentLoaded', () => {
	const container = document.getElementById( 'quizpresswrap' );
	if ( container ) {
		const root = createRoot( container );
		const menuPage = document.getElementById( 'toplevel_page_quizpress' );
		function MenuPortal( { children } ) {
			menuPage.innerHTML = '';
			return createPortal( children, menuPage );
		}
		root.render(
			<Provider store={ store }>
				<ChakraProvider value={ theme }>
					<Router>
						<MenuPortal>
							<AdminMenu />
						</MenuPortal>
						<BackendDashboard />
					</Router>
				</ChakraProvider>
			</Provider>
		);
	}
} );
