import { Field } from 'formik';
import React, { useState } from 'react';
import { plugin_root_url } from '@QPUtils/helper';
import DropdownSelect from '@QPComponents/Formik/DropdownSelectControl';
import SwitchControl from '@QPComponents/Formik/SwitchControl';

const AdvanceSettings = () => {
	const [ isActive, setActive ] = useState( 'false' );
	const handleToggle = () => {
		setActive( ! isActive );
	};

	return (
		<div
			className={
				isActive
					? 'advance-settings-fields-wrapper close'
					: 'advance-settings-fields-wrapper open'
			}
		>
			<div className="advance-setting-title" onClick={ handleToggle }>
				<div className="icon">
					<img
						src={ plugin_root_url + 'assets/images/settings.png' }
						alt=""
					/>
				</div>
				<div className="text">Advance Settings</div>
			</div>
			<div className="advance-setting-fields">
				<div className="quizpress-form-group">
					<div className="switch-field-wrapper">
						<Field name="auto_start" component={ SwitchControl } />

						<span>Randomize</span>
					</div>
					<p>
						If you enable this option, the quiz will start
						automatically after the page is loaded.
					</p>
				</div>
				<div className="quizpress-form-group">
					<div className="quizpress-d-flex">
						<div className="form-group quizpress-w-50">
							<label htmlFor="ques_layout">Question Layout</label>
							<Field
								id="ques_layout"
								name="ques_layout"
								component={ DropdownSelect }
							/>
						</div>
						<div className="form-group quizpress-w-50">
							<label htmlFor="ques_order">Questions Order</label>
							<Field
								id="ques_order"
								name="ques_order"
								component={ DropdownSelect }
							/>
						</div>
					</div>
				</div>
				<div className="quizpress-form-group">
					<div className="switch-field-wrapper">
						<Field
							name="hide_ques_number"
							component={ SwitchControl }
						/>
						<span>Hide question number</span>
					</div>
					<p>Show/hide question number during attempt.</p>
				</div>

				<div className="quizpress-form-group">
					<label htmlFor="sort_character_limit">
						Short answer characters limit
					</label>
					<Field
						id="sort_character_limit"
						name="sort_character_limit"
						type="number"
					/>
					<p className="guid-desc m-0">
						Student will place answer in short answer question type
						within this characters limit.
					</p>
				</div>

				<div className="quizpress-form-group">
					<label htmlFor="essay_ques_car_limit">
						Open-Ended/Essay questions answer character limit
					</label>
					<Field
						id="essay_ques_car_limit"
						name="essay_ques_car_limit"
						type="number"
					/>
					<p className="guid-desc m-0">
						Student will place answer in short answer question type
						within this characters limit.
					</p>
				</div>
			</div>
		</div>
	);
};

export default AdvanceSettings;
