import React, { useEffect, useRef } from 'react';
import { __ } from '@wordpress/i18n';
import { createPortal } from 'react-dom';
import PropTypes from 'prop-types';
import Button from '@QPComponents/Button';
import './styles.scss';

const propTypes = {
	actionButtons: PropTypes.array,
	itemsLength: PropTypes.number,
	isActionSelected: PropTypes.object,
	confirmHandler: PropTypes.function,
	resetHandler: PropTypes.function,
};

const SnackbarAction = ( {
	actionButtons,
	itemsLength,
	isActionSelected,
	confirmHandler,
	resetHandler,
} ) => {
	const snackbarRef = useRef( null );
	const targetElement =
		document.querySelector( '#quizpresswrap' ) ||
		document.querySelector( '#quizpressFrontendDashWrap' ) ||
		document.querySelector( '#quizpressLessonsWrap' ) ||
		document.querySelector( '#quizpress_frontend_dashboard_react_render' );

	useEffect( () => {
		if ( itemsLength && targetElement ) {
			snackbarRef.current.style.position = 'fixed';
			snackbarRef.current.style.left = `40%`; // Adjust left position as needed
			snackbarRef.current.style.bottom = `50px`; // Place it at the bottom
			document.body.appendChild( snackbarRef.current );
		} else if (
			snackbarRef.current &&
			snackbarRef.current.parentNode === document.body
		) {
			document.body.removeChild( snackbarRef.current );
		}

		return () => {
			if (
				snackbarRef.current &&
				snackbarRef.current.parentNode === document.body
			) {
				document.body.removeChild( snackbarRef.current );
			}
		};
	}, [] );

	return (
		<>
			{ itemsLength &&
				createPortal(
					<div
						className="quizpress-snackbar-action"
						ref={ snackbarRef }
					>
						<Button
							icon={
								<span className="quizpress-icon quizpress-icon--close"></span>
							}
							preset="transparent"
							suffix="close"
							onClick={ resetHandler }
						/>
						{ isActionSelected?.value ? (
							<div className="quizpress-snackbar-action__after">
								<div className="quizpress-snackbar-action__left">
									{ isActionSelected?.message }
								</div>
								<div className="quizpress-snackbar-action__left">
									<Button
										label={ __( 'Cancel', 'quizpress' ) }
										onClick={ resetHandler }
										preset="transparent"
										border="gray"
									/>
									<Button
										label={ __( 'Confirm', 'quizpress' ) }
										onClick={ () => confirmHandler( true ) }
										suffix="confirm"
									/>
								</div>
							</div>
						) : (
							<div className="quizpress-snackbar-action__before">
								<div className="quizpress-snackbar-action__left">
									<div className="quizpress-snackbar-action__items-length">
										<span className="">
											{ itemsLength }
										</span>
										<p>
											{ __(
												'Items selected',
												'quizpress'
											) }
										</p>
									</div>
								</div>
								<div className="quizpress-snackbar-action__right">
									{ actionButtons.map(
										( actionButton, index ) => (
											<Button
												{ ...actionButton }
												key={ index }
											/>
										)
									) }
								</div>
							</div>
						) }
					</div>,
					document.body
				) }
		</>
	);
};

SnackbarAction.propTypes = propTypes;
export default SnackbarAction;
