import React from 'react';
import { Formik, Form, Field } from 'formik';

const FeedbackRadioControl = ( {
	field, // { name, value, onChange, onBlur}
	form: { touched, errors },
	...props
} ) => (
	<>
		<label className="quizpress-radio">
			<input
				type="radio"
				placeholder={ props.placeholder }
				{ ...field }
				{ ...props }
				checked={ props.value === field.value }
			/>
			<span>
				<div className="text">
					<h3>{ props.value }</h3>
					<p className="desc">{ props.desc }</p>
				</div>
			</span>
		</label>

		{ errors[ field.name ] && touched[ field.name ] ? (
			<span>{ errors[ field.name ] }</span>
		) : null }
	</>
);

export default FeedbackRadioControl;
