import React from 'react';
import { Formik, Form, Field } from 'formik';

const RadioControl = ( {
	field, // { name, value, onChange, onBlur}
	form: { touched, errors },
	...props
} ) => (
	<>
		<label className="quizpress-radio">
			<input
				type="radio"
				placeholder={ props.placeholder }
				{ ...field }
				{ ...props }
				checked={ props.value === field.value }
			/>
			<span>{ props.value }</span>
		</label>

		{ errors[ field.name ] && touched[ field.name ] ? (
			<span>{ errors[ field.name ] }</span>
		) : null }
	</>
);

export default RadioControl;
