import React, { Component } from 'react';
import { render } from 'react-dom';
// import { sortableContainer, sortableElement } from 'react-sortable-hoc';
import { arrayMove, arrayMoveImmutable, arrayMoveMutable } from 'array-move';
const sortableElement = () => {};
const sortableContainer = () => {};

const SortableItem = sortableElement( ( { value } ) => (
	<li className="quizpress-sortable-item">
		<div className="text">
			<span> { value.label } </span>
			<input
				name="sort"
				type="radio"
				defaultChecked={ value.value === true }
			/>
		</div>
		<span className="bars">
			<span></span>
			<span></span>
			<span></span>
		</span>
	</li>
) );

const SortableContainer = sortableContainer( ( { children } ) => {
	return <ul>{ children }</ul>;
} );

class SortableControl extends Component {
	constructor( {
		field, // { name, value, onChange, onBlur}
		form: { touched, errors },
		...props
	} ) {
		super( field );
		this.state = {
			items: field.value,
		};
	}

	// state = {
	//   items: ['Alamin', 'Joynal'],
	// };

	onSortEnd = ( { oldIndex, newIndex } ) => {
		this.setState( ( { items } ) => ( {
			items: arrayMoveImmutable( items, oldIndex, newIndex ),
		} ) );
	};

	render() {
		const { items } = this.state;
		return (
			<div className="quizpress-sortable-wrapper">
				{ /* <SortableContainer onSortEnd={ this.onSortEnd }>
					{ items.map( ( value, index ) => (
						<SortableItem
							key={ `item-${ value }` }
							index={ index }
							value={ value }
						/>
					) ) }
				</SortableContainer> */ }
			</div>
		);
	}
}
export default SortableControl;
