import React from 'react';
import { __ } from '@wordpress/i18n';
import { Flex, Circle, Text, Box } from '@chakra-ui/react';
import { Span } from '@chakra-ui/react';

const Stepper = ( { steps, currentStepIndex, onStepClick } ) => {
	return (
		<Flex align="center" gap={ 3 }>
			{ steps.map( ( step, idx ) => {
				const isActive = idx === currentStepIndex;
				const isCompleted = idx < currentStepIndex;

				return (
					<Flex
						key={ idx }
						align="center"
						gap={ 2 }
						cursor={ onStepClick ? 'pointer' : 'default' }
						onClick={ () => onStepClick && onStepClick( idx ) }
					>
						<Circle
							size="36px"
							bg={
								isActive
									? 'var(--quizpress-primary)'
									: isCompleted
									? 'var(--quizpress-body-background)'
									: 'var(--quizpress-body-background)'
							}
							color={
								isActive
									? 'var(--quizpress-background)'
									: isCompleted &&
									  'var(--quizpress-font-color)'
							}
							border={
								! isActive &&
								'1px solid var(--quizpress-border-color)'
							}
							fontWeight="600"
							transition="all 0.2s"
						>
							{ isCompleted ? (
								<Span className="quizpress-icon quizpress-icon--check" />
							) : (
								idx + 1
							) }
						</Circle>
						<Text
							fontWeight="600"
							color={
								isActive
									? 'var(--quizpress-primary)'
									: 'var(--quizpress-font-color)'
							}
							whiteSpace="nowrap"
						>
							{ __( step.title, 'quizpress' ) }
						</Text>
						{ idx !== steps.length - 1 && (
							<Box
								width="36px"
								h="2px"
								bg="var(--quizpress-border-color)"
							/>
						) }
					</Flex>
				);
			} ) }
		</Flex>
	);
};

export default Stepper;
