import React from 'react';

const SwitchControl = ( { field, form: { touched, errors }, ...props } ) => (
	<>
		<div className="quizpress-control-switch">
			<label className="quizpress-switch">
				<input
					type="checkbox"
					className="form-control"
					{ ...field }
					{ ...props }
					defaultChecked={ field.value }
				/>
				<span className="quizpress-slider"></span>
			</label>
			<span className="switch-title"></span>
			{ errors[ field.name ] && touched[ field.name ] ? (
				<span className="quizpress-control-switch__error">
					{ errors[ field.name ] }
				</span>
			) : null }
		</div>
	</>
);

export default SwitchControl;
