import React from 'react';
import { __ } from '@wordpress/i18n';
import { Flex, Span } from '@chakra-ui/react';

const GstText = ( {
	label,
	type = 'info',
	showBorder = false,
	subtitle = false,
	button = null,
} ) => {
	let styles = {};

	if ( type === 'info' ) {
		styles = {
			bg: '#E9F0FF',
			color: 'var(--quizpress-primary)',
		};
	} else if ( type === 'warning' ) {
		styles = {
			bg: '#FFF7E9',
			color: 'var(--quizpress-warning)',
		};
	}

	const borderStyle = () => {
		switch ( type ) {
			case 'info':
				return '1px solid var(--quizpress-primary)';
			case 'warning':
				return '1px solid var(--quizpress-warning)';
			default:
				return '1px solid var(--quizpress-primary)';
		}
	};
	return (
		<Flex
			width="full"
			padding="1.5rem"
			direction="column"
			justifyContent="center"
			alignItems="center"
			gap="1rem"
			borderRadius="4px"
			{ ...styles }
			border={ showBorder ? borderStyle() : 'none' }
		>
			<Span
				textAlign="center"
				fontSize={ type === 'info' ? '1.25rem' : '1rem' }
				lineHeight="1.25rem"
			>
				{ label }
			</Span>
			{ subtitle && (
				<Span
					textAlign="center"
					fontSize="0.875rem"
					fontWeight="medium"
					lineHeight="1rem"
					color="var(--quizpress-secondary)"
				>
					{ subtitle }
				</Span>
			) }
			{ button }
		</Flex>
	);
};

export default GstText;
