import React from 'react';
import { __ } from '@wordpress/i18n';

import Preloader from '@QPComponents/Loader/Preloader';
import CustomTableMessage from '@QPComponents/Oops/CustomTableMessage';

const TableBody = ( {
	dataFetchingStatus,
	copyDataArr,
	visibleColumn,
	isCheckboxColumnVisible,
	selectRowChange,
	noDataText,
	loadingHeight,
	bodyRef,
	button,
	hoverAction,
} ) => {
	const isLoading = dataFetchingStatus || ! copyDataArr;

	return (
		<div className="quizpress-table__body-wrap" ref={ bodyRef }>
			{ isLoading ? (
				<div
					className="quizpress-table__loader"
					style={ { minHeight: loadingHeight } }
				>
					<Preloader />
				</div>
			) : (
				<>
					{ copyDataArr?.length > 0 ? (
						<>
							{ copyDataArr?.map( ( row, index ) => (
								<div
									key={ index }
									className={ `quizpress-table__body-row-wrap ${
										hoverAction
											? 'quizpress-table__body-row-hovered'
											: ''
									}` }
								>
									{ isCheckboxColumnVisible && (
										<div className="quizpress-table__row-cell quizpress-table__row-cell-checkbox ">
											<input
												type="checkbox"
												checked={ row.select }
												onChange={ ( event ) =>
													selectRowChange( {
														row,
														select: event.target
															.checked,
													} )
												}
											/>
										</div>
									) }
									{ visibleColumn.length > 0 ? (
										<>
											{ visibleColumn?.map(
												(
													copyColumn,
													copyColumnIndex
												) => (
													<>
														<div
															className={ `quizpress-table__body-row-cell ${
																hoverAction
																	? 'quizpress-table__row-cell-hovered'
																	: ''
															} ${
																copyColumn.isWidth ??
																'quizpress-table__body-row-cell-width'
															}` }
															key={
																copyColumnIndex
															}
														>
															{ copyColumn?.cell(
																row,
																index
															) }

															{ copyColumnIndex ===
																0 &&
																hoverAction &&
																typeof hoverAction.cell ===
																	'function' && (
																	<span className="quizpress-table__hover-action">
																		{ hoverAction.cell(
																			row,
																			index
																		) }
																	</span>
																) }
														</div>
													</>
												)
											) }
										</>
									) : (
										<CustomTableMessage
											title={ __(
												'No visible columns available!!',
												'quizpress'
											) }
										/>
									) }
								</div>
							) ) }
						</>
					) : (
						<CustomTableMessage
							title={ __( 'No Data Available!!!', 'quizpress' ) }
							subText={ noDataText }
							button={ button }
						/>
					) }
				</>
			) }
		</div>
	);
};

export default TableBody;
