import React from 'react';
import { __, sprintf } from '@wordpress/i18n';
import { Text } from '@chakra-ui/react';
import Pagination from '@QPComponents/Pagination';
import Select from 'react-select';

const options = [
	{ value: '10', label: __( '10', 'quizpress' ) },
	{ value: '15', label: __( '15', 'quizpress' ) },
	{ value: '20', label: __( '20', 'quizpress' ) },
	{ value: '25', label: __( '25', 'quizpress' ) },
	{ value: '30', label: __( '30', 'quizpress' ) },
];

const TableFooter = ( {
	data,
	totalItems,
	paginationPerPageChange,
	rowsPerPage,
	onChangePage,
	currentPageNumber,
} ) => {
	React.useEffect( () => {
		const selector = document.getElementById(
			'quizpress-table-row-per-page-selector'
		);
		selector.childNodes.forEach( function ( element ) {
			if ( element.className.includes( 'quizpress-select__control' ) ) {
				return ( element.id =
					'quizpress-table-row-per-page-selector-control' );
			}
			return element;
		} );
		const selectorControl = document.getElementById(
			'quizpress-table-row-per-page-selector-control'
		);
		selectorControl.childNodes.forEach( function ( element ) {
			if (
				element.className.includes( 'quizpress-select__indicators' )
			) {
				return ( element.id =
					'quizpress-table-row-per-page-selector-indicators' );
			}
			return element;
		} );
		const selectorIndicators = document.getElementById(
			'quizpress-table-row-per-page-selector-indicators'
		);
		selectorIndicators.removeChild( selectorIndicators.childNodes[ 0 ] );
		selectorIndicators.childNodes[ 0 ].style.padding = '0 8px 0 0';
		selectorControl.childNodes[ 0 ].style.padding = '2px 0px 0px 8px';
	}, [] );

	return (
		<div className="quizpress-table__footer">
			<Text
				color="var(--quizpress-font-color)"
				fontSize="sm"
				fontWeight="normal"
			>
				{ /* eslint-disable-next-line */ }
				{sprintf(
					// translators: %s: totalItems
					__( 'Showing result %s out of %s', 'quizpress' ),
					data?.length,
					totalItems
				) }
			</Text>

			<div className="quizpress-table__footer-right">
				<div className="quizpress-table__footer-pagination per__page">
					<Text
						color="var(--quizpress-font-color)"
						fontSize="sm"
						fontWeight="normal"
					>
						{ __( 'Rows per page', 'quizpress' ) }
					</Text>

					<Select
						id="quizpress-table-row-per-page-selector"
						menuPlacement="top"
						className="quizpress-select"
						classNamePrefix="quizpress-select"
						options={ options }
						value={
							rowsPerPage
								? options.find(
										( item ) =>
											Number( item.value ) ===
											Number( rowsPerPage )
								  )
								: options[ 0 ]
						}
						onChange={ paginationPerPageChange }
					/>
				</div>
				<div className="quizpress-table__footer-pagination-pages icons">
					<Pagination
						totalItems={ totalItems }
						fetchHandler={ onChangePage }
						currentPageNumber={ currentPageNumber }
						rowsPerPage={ rowsPerPage }
					/>
				</div>
			</div>
		</div>
	);
};

export default TableFooter;
