import { __ } from '@wordpress/i18n';
import { useEffect } from 'react';
import Button from '@QPComponents/Button';
import { plugin_root_url } from '@QPUtils/helper';
import { Flex } from '@chakra-ui/react';

import './styles.scss';

const ProgressModal = ( {
	show = false,
	close,
	progress = 0,
	isComplete = false,
	title,
	progressMessage,
	successTitle,
	successMessage,
} ) => {
	useEffect( () => {
		if ( show ) {
			document.body.classList.add( 'quizpress-progress-modal--open' );
			if ( progress && progress !== 100 ) {
				window.onbeforeunload = function () {
					return __( 'Process is not complete.' );
				};
			}
		}

		return () => {
			document.body.classList.remove( 'quizpress-progress-modal--open' );
			window.onbeforeunload = null;
		};
	}, [ show, progress ] );

	return (
		show && (
			<dialog
				className="quizpress-progress-modal"
				open={ show }
				role="alertdialog"
				aria-modal={ true }
				aria-live="polite"
			>
				<div className="quizpress-progress-modal__wrapper">
					{ isComplete === true && progress === 100 ? (
						<>
							<Flex justifyContent="center">
								<img
									src={
										plugin_root_url +
										'assets/images/checkmark-badge.png'
									}
									alt={ __( 'Congratulations', 'quizpress' ) }
								/>
							</Flex>
							<p className="quizpress-progress-modal__completed-title">
								{ successTitle }
							</p>
							<p className="quizpress-progress-modal__completed-subtitle">
								{ successMessage }
							</p>
							<div className="quizpress-progress-modal__footer">
								<Button
									type="button"
									label={ __( 'Close', 'quizpress' ) }
									onClick={ close }
									suffix="close"
									preset="white"
									border="gray"
								/>
							</div>
						</>
					) : (
						<>
							<h3 id="progressbar_title">{ title }</h3>
							<p
								id="progressbar_status"
								className="quizpress-mirgation-subtitle"
							>
								{ progressMessage }
							</p>
							<div className="quizpress-progress-modal__progress--wrapper">
								<div
									className="quizpress-progress-modal__progress--bar"
									role="progressbar"
									aria-labelledby="progressbar_title"
									aria-describedby="progressbar_status"
									aria-busy="true"
									aria-valuenow={ progress }
									aria-valuemin={ 0 }
									aria-valuemax={ 100 }
								>
									<div
										className="quizpress-progress-modal__progress--progress"
										style={ { width: `${ progress }%` } }
									/>
								</div>
								<p aria-hidden={ true }>{ progress }%</p>
							</div>
							<div className="quizpress-progress-modal__footer">
								<Button
									type="button"
									label={ __(
										'Cancel Download',
										'quizpress'
									) }
									onClick={ close }
									suffix="close"
									preset="white"
									border="gray"
								/>
							</div>
						</>
					) }
				</div>
			</dialog>
		)
	);
};
export default ProgressModal;
