import React, { useState } from 'react';
import { __ } from '@wordpress/i18n';
import ReactModalFormik from '@QPComponents/Modal/ReactModalFormik';
import {
	CloseButton,
	FileUpload,
	Flex,
	Input,
	InputGroup,
	Span,
	Text,
} from '@chakra-ui/react';

const QuestionsImporter = ( { isOpen, onClose, handleSubmit } ) => {
	const [ uploadFile, setUploadFile ] = useState( null );

	return (
		<ReactModalFormik
			isOpen={ isOpen }
			onRequestClose={ onClose }
			submitButtonLabel={ __( 'Import', 'quizpress' ) }
			title={ __( 'Import Questions', 'quizpress' ) }
			isEnabledFooter={ true }
			isEnabledResizer={ false }
			size="small"
			formik={ {
				enableReinitialize: true,
				initialValues: {
					upload_file: uploadFile,
				},
				onSubmit: handleSubmit,
			} }
		>
			<Flex direction="column" gap={ 3 }>
				<Text className="quizpress-title quizpress-title-required">
					{ __( 'Select a CSV file', 'quizpress' ) }
					<Span className="quizpress-title-required--sign">*</Span>
				</Text>

				<FileUpload.Root
					maxW="xl"
					alignItems="stretch"
					maxFiles={ 1 }
					allowDrop={ true }
					preventDocumentDrop={ false }
					accept={ [ '.csv', 'text/csv' ] }
					name="  "
					required={ true }
					onFileChange={ ( e ) => {
						setUploadFile( e.acceptedFiles[ 0 ] );
					} }
					onFileReject={ ( e ) => {
						setUploadFile( null );
					} }
				>
					<FileUpload.HiddenInput />
					<InputGroup
						endElement={
							<FileUpload.ClearTrigger asChild>
								<CloseButton
									me="-1"
									size="xs"
									variant="plain"
									focusVisibleRing="inside"
									focusRingWidth="2px"
									pointerEvents="auto"
								/>
							</FileUpload.ClearTrigger>
						}
					>
						<Input asChild>
							<FileUpload.Trigger>
								<FileUpload.FileText lineClamp={ 1 } />
							</FileUpload.Trigger>
						</Input>
					</InputGroup>
				</FileUpload.Root>
			</Flex>
		</ReactModalFormik>
	);
};

export default QuestionsImporter;
