import React, { useState } from 'react';

import './styles.scss';

const QPTooltip = ( {
	children,
	content,
	position = 'top',
	showArrow = true,
	disabled = false,
	type = false,
	width = 'auto',
	noWrap = false,
} ) => {
	const [ visible, setVisible ] = useState( false );
	const shouldShow = ! disabled && content;

	return (
		<div
			className="quizpress-tooltip"
			onMouseEnter={ () => shouldShow && setVisible( true ) }
			onMouseLeave={ () => shouldShow && setVisible( false ) }
		>
			{ type === 'info' && (
				<span className="quizpress-icon quizpress-icon--info" />
			) }
			{ type === 'ques' && (
				<span className="quizpress-icon quizpress-icon--questions" />
			) }
			{ type === 'pro' && (
				<span className="quizpress-icon quizpress-icon--lock-light" />
			) }
			{ children }
			{ shouldShow && visible && (
				<div
					className={ `quizpress-tooltip__box quizpress-tooltip__box--${ position }` }
					style={ {
						width,
						whiteSpace: noWrap ? 'nowrap' : 'normal',
						overflowWrap: 'break-word',
						wordBreak: 'break-word',
					} }
				>
					{ content }
					{ showArrow && (
						<div
							className={ `quizpress-tooltip__arrow quizpress-tooltip__arrow--${ position }` }
						/>
					) }
				</div>
			) }
		</div>
	);
};

export default QPTooltip;
