import React from 'react';
import { Formik, Field, Form } from 'formik';
import SwitchControl from '@QPComponents/Formik/SwitchControl';
import RadioControl from '@QPComponents/Formik/RadioControl';
import DropdownSelectControl from '@QPComponents/Formik/DropdownSelectControl';
import SortableControl from '@QPComponents/Formik/SortableControl';
import { questionSchema } from '@QPUtils/helper';
import PropTypes from 'prop-types';

const propTypes = {};

const defaultProps = {};

export default function QuestionForm( { addQuestionHandler } ) {
	return (
		<React.Fragment>
			<div className="quizpress-question-form">
				<Formik
					initialValues={ questionSchema }
					onSubmit={ ( values ) => {
						addQuestionHandler( values );
					} }
				>
					<Form>
						<div className="quizpress-question-form__field">
							<div className="quizpress-form-group">
								<label htmlFor="questionTitle">
									Write your question here
								</label>
								<Field id="questionTitle" name="title" />
							</div>
							<div className="quizpress-form-group">
								<label htmlFor="questionType">
									Question Type
								</label>
								<Field
									id="questionType"
									name="type"
									component={ DropdownSelectControl }
								/>
							</div>

							<div className="quizpress-question-form-d-flex">
								<div className="quizpress-form-group">
									<div className="switch-field-wrapper">
										<Field
											name="answer_required"
											component={ SwitchControl }
										/>
										<span>Answer required</span>
									</div>
								</div>

								<div className="quizpress-form-group">
									<div className="switch-field-wrapper">
										<Field
											name="randomize"
											component={ SwitchControl }
										/>
										<span>Randomize</span>
									</div>
								</div>
							</div>

							<div className="quizpress-form-group">
								<label htmlFor="points">
									Point(s) for this answer
								</label>
								<div className="quizpress-d-flex">
									<Field id="points" name="points" />
									<div className="quizpress-form-group">
										<div className="switch-field-wrapper">
											<Field
												name="display_points"
												component={ SwitchControl }
											/>
											<span>Display points</span>
										</div>
									</div>
								</div>
							</div>

							<div className="quizpress-form-group">
								<label htmlFor="questionDesc">
									Description (Optional)
								</label>
								<Field
									id="questionDesc"
									as="textarea"
									name="description"
								/>
							</div>

							<div className="quizpress-form-group">
								<label htmlFor="questionDesc">
									Select your topic
								</label>
								<div className="quizpress-switch-fields-wrapper">
									<Field
										name="topic"
										component={ RadioControl }
										value="HTML"
									/>
									<Field
										name="topic"
										component={ RadioControl }
										value="CSS"
									/>
									<Field
										name="topic"
										component={ RadioControl }
										value="JavaScript"
									/>
								</div>
							</div>
							<div className="quizpress-form-group">
								<Field
									name="sort"
									component={ SortableControl }
									value="JavaScript"
								/>
							</div>
						</div>
						<button type="submit">Add Question</button>
					</Form>
				</Formik>
			</div>
		</React.Fragment>
	);
}

QuestionForm.propTypes = propTypes;
QuestionForm.defaultProps = defaultProps;
