import React from 'react';
import { __ } from '@wordpress/i18n';
import { Checkbox, Span, Stack } from '@chakra-ui/react';

import './styles.scss';

const QuizPressCheckbox = ( {
	title = null,
	subtitle = false,
	size = 'md',
	fontWeight = '400',
	fontSize = '1rem',
	variant = 'solid',
	rootStyles = {
		flexDirection: 'row',
		alignItems: 'flex-start',
	},
	onChange = () => {},
	...rootProps
} ) => {
	return (
		<Checkbox.Root
			gap="4"
			size={ size }
			variant={ variant }
			onCheckedChange={ onChange }
			cursor={ rootProps?.readOnly ? 'not-allowed' : 'pointer' }
			className="quizpress-checkbox"
			{ ...rootStyles }
			{ ...rootProps }
		>
			<Checkbox.HiddenInput />
			<Checkbox.Control className="quizpress-checkbox__control" />
			<Stack gap="1">
				{ title && (
					<Checkbox.Label
						fontWeight={ fontWeight }
						fontSize={ fontSize }
					>
						{ title }
					</Checkbox.Label>
				) }
				{ subtitle && (
					<Span
						className="quizpress-sub-title"
						color="var(--quizpress-warn-muted)"
					>
						{ subtitle }
					</Span>
				) }
			</Stack>
		</Checkbox.Root>
	);
};

export default QuizPressCheckbox;
