import React, { useState } from 'react';
import MonacoEditor from '@monaco-editor/react';
import { monacoOptions } from './helper';
import './styles.scss';

const MonacoCodeEditor = ( { value, saveHandler } ) => {
	const [ editorText, setEditorText ] = useState( value );
	return (
		<MonacoEditor
			className="quizpress-code-editor"
			height="400px"
			width="100%"
			language="html"
			value={ editorText }
			theme="vs-dark"
			onChange={ ( value ) => {
				setEditorText( value );
				saveHandler( value );
			} }
			options={ monacoOptions }
		/>
	);
};

export default MonacoCodeEditor;
