export const imageIcon = () => {
	return (
		<svg
			width="16"
			height="16"
			viewBox="0 0 16 16"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				d="M2 2C1.44687 2 1 2.44687 1 3V10.2937L3.11562 8.17813C3.60312 7.69063 4.39375 7.69063 4.88438 8.17813L7 10.2937L11.1156 6.17812C11.6031 5.69062 12.3937 5.69062 12.8844 6.17812L15 8.29375V3C15 2.44687 14.5531 2 14 2H2ZM1 11.7063V13C1 13.5531 1.44687 14 2 14H3.29375L6.29375 11L4.17812 8.88437C4.08125 8.7875 3.92188 8.7875 3.825 8.88437L1 11.7063ZM12.1781 6.88438C12.0813 6.7875 11.9219 6.7875 11.825 6.88438L4.70625 14H14C14.5531 14 15 13.5531 15 13V9.70625L12.1781 6.88438ZM0 3C0 1.89688 0.896875 1 2 1H14C15.1031 1 16 1.89688 16 3V13C16 14.1031 15.1031 15 14 15H2C0.896875 15 0 14.1031 0 13V3ZM5 4.5C5 4.36739 4.94732 4.24021 4.85355 4.14645C4.75979 4.05268 4.63261 4 4.5 4C4.36739 4 4.24021 4.05268 4.14645 4.14645C4.05268 4.24021 4 4.36739 4 4.5C4 4.63261 4.05268 4.75979 4.14645 4.85355C4.24021 4.94732 4.36739 5 4.5 5C4.63261 5 4.75979 4.94732 4.85355 4.85355C4.94732 4.75979 5 4.63261 5 4.5ZM3 4.5C3 4.10218 3.15804 3.72064 3.43934 3.43934C3.72064 3.15804 4.10218 3 4.5 3C4.89782 3 5.27936 3.15804 5.56066 3.43934C5.84196 3.72064 6 4.10218 6 4.5C6 4.89782 5.84196 5.27936 5.56066 5.56066C5.27936 5.84196 4.89782 6 4.5 6C4.10218 6 3.72064 5.84196 3.43934 5.56066C3.15804 5.27936 3 4.89782 3 4.5Z"
				fill="#0F0E16"
			/>
		</svg>
	);
};

export const videoIcon = () => {
	return (
		<svg
			width="18"
			height="16"
			viewBox="0 0 18 16"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				d="M2 3C1.44687 3 1 3.44687 1 4V12C1 12.5531 1.44687 13 2 13H10C10.5531 13 11 12.5531 11 12V4C11 3.44687 10.5531 3 10 3H2ZM0 4C0 2.89688 0.896875 2 2 2H10C11.1031 2 12 2.89688 12 4V5.475V10.525V12C12 13.1031 11.1031 14 10 14H2C0.896875 14 0 13.1031 0 12V4ZM16.2313 12.8531L13 11.075V9.93437L16.7125 11.9781C16.7406 11.9937 16.7719 12.0031 16.8062 12.0031C16.9125 12.0031 17 11.9156 17 11.8094V4.19688C17 4.09063 16.9125 4.00313 16.8062 4.00313C16.775 4.00313 16.7406 4.0125 16.7125 4.02812L13 6.06563V4.925L16.2313 3.14687C16.4063 3.05 16.6062 3 16.8062 3C17.4656 3 18 3.53437 18 4.19375V11.8062C18 12.4656 17.4656 13 16.8062 13C16.6062 13 16.4063 12.95 16.2313 12.8531Z"
				fill="#0F0E16"
			/>
		</svg>
	);
};

export const tableIcon = () => {
	return (
		<svg
			width="16"
			height="16"
			viewBox="0 0 16 16"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				d="M2 2C1.44687 2 1 2.44687 1 3V5H15V3C15 2.44687 14.5531 2 14 2H2ZM1 6V9.5H7.5V6H1ZM8.5 6V9.5H15V6H8.5ZM7.5 10.5H1V13C1 13.5531 1.44687 14 2 14H7.5V10.5ZM8.5 14H14C14.5531 14 15 13.5531 15 13V10.5H8.5V14ZM0 3C0 1.89688 0.896875 1 2 1H14C15.1031 1 16 1.89688 16 3V13C16 14.1031 15.1031 15 14 15H2C0.896875 15 0 14.1031 0 13V3Z"
				fill="#0F0E16"
			/>
		</svg>
	);
};

export const pdfIcon = () => {
	return (
		<svg
			width="16"
			height="16"
			viewBox="0 0 16 16"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g clipPath="url(#clip0_10737_13813)">
				<path
					d="M2 15H3.5V16H2C0.896875 16 0 15.1031 0 14V2C0 0.896875 0.896875 0 2 0H6.87813C7.275 0 7.65625 0.159375 7.9375 0.440625L11.5594 4.05937C11.8406 4.34062 12 4.72188 12 5.11875V9.5H11V6H7.5C6.67188 6 6 5.32812 6 4.5V1H2C1.44687 1 1 1.44687 1 2V14C1 14.5531 1.44687 15 2 15ZM10.9844 5C10.9625 4.9125 10.9187 4.83125 10.8531 4.76875L7.23125 1.14688C7.16562 1.08125 7.0875 1.0375 7 1.01562V4.5C7 4.775 7.225 5 7.5 5H10.9844ZM5.5 11H6.5C7.46562 11 8.25 11.7844 8.25 12.75C8.25 13.7156 7.46562 14.5 6.5 14.5H6V15.5C6 15.775 5.775 16 5.5 16C5.225 16 5 15.775 5 15.5V14V11.5C5 11.225 5.225 11 5.5 11ZM6.5 13.5C6.91563 13.5 7.25 13.1656 7.25 12.75C7.25 12.3344 6.91563 12 6.5 12H6V13.5H6.5ZM9.5 11H10.5C11.3281 11 12 11.6719 12 12.5V14.5C12 15.3281 11.3281 16 10.5 16H9.5C9.225 16 9 15.775 9 15.5V11.5C9 11.225 9.225 11 9.5 11ZM10.5 15C10.775 15 11 14.775 11 14.5V12.5C11 12.225 10.775 12 10.5 12H10V15H10.5ZM13 11.5C13 11.225 13.225 11 13.5 11H15C15.275 11 15.5 11.225 15.5 11.5C15.5 11.775 15.275 12 15 12H14V13H15C15.275 13 15.5 13.225 15.5 13.5C15.5 13.775 15.275 14 15 14H14V15.5C14 15.775 13.775 16 13.5 16C13.225 16 13 15.775 13 15.5V13.5V11.5Z"
					fill="#0F0E16"
				/>
			</g>
			<defs>
				<clipPath id="clip0_10737_13813">
					<rect width="16" height="16" fill="white" />
				</clipPath>
			</defs>
		</svg>
	);
};

export const penIcon = () => {
	return (
		<svg
			width="16"
			height="16"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a1.003 1.003 0 000-1.42l-2.34-2.34a1.003 1.003 0 00-1.42 0l-1.83 1.83 3.75 3.75 1.84-1.82z"
				fill="black"
			/>
		</svg>
	);
};

export const textIcon = () => {
	return (
		<svg
			width="16"
			height="16"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				d="M12 4L7 20H9L10.25 16H13.75L15 20H17L12 4ZM11.1 14L12 10.67L12.9 14H11.1Z"
				fill="black"
			/>
		</svg>
	);
};

// Text alignment icons
export const align = () => {
	return (
		<svg
			width="16"
			height="16"
			viewBox="0 0 16 16"
			role="img"
			aria-labelledby="title-center"
			xmlns="http://www.w3.org/2000/svg"
		>
			<rect
				x="5"
				y="5"
				width="14"
				height="2"
				rx="1"
				fill="currentColor"
			/>
			<rect
				x="3"
				y="10"
				width="18"
				height="2"
				rx="1"
				fill="currentColor"
			/>
			<rect
				x="7"
				y="15"
				width="10"
				height="2"
				rx="1"
				fill="currentColor"
			/>
		</svg>
	);
};

export const bulletIcon = () => {
	return (
		<svg
			width="24"
			height="24"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<circle cx="5" cy="6" r="1.5" fill="currentColor" />
			<circle cx="5" cy="12" r="1.5" fill="currentColor" />
			<circle cx="5" cy="18" r="1.5" fill="currentColor" />
			<rect
				x="9"
				y="5"
				width="12"
				height="2"
				rx="1"
				fill="currentColor"
			/>
			<rect
				x="9"
				y="11"
				width="12"
				height="2"
				rx="1"
				fill="currentColor"
			/>
			<rect
				x="9"
				y="17"
				width="12"
				height="2"
				rx="1"
				fill="currentColor"
			/>
		</svg>
	);
};

export const numberIcon = () => {
	return (
		<svg
			width="24"
			height="24"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<text x="3" y="8" fontSize="6" fill="currentColor">
				1
			</text>
			<text x="3" y="14" fontSize="6" fill="currentColor">
				2
			</text>
			<text x="3" y="20" fontSize="6" fill="currentColor">
				3
			</text>
			<rect
				x="9"
				y="5"
				width="12"
				height="2"
				rx="1"
				fill="currentColor"
			/>
			<rect
				x="9"
				y="11"
				width="12"
				height="2"
				rx="1"
				fill="currentColor"
			/>
			<rect
				x="9"
				y="17"
				width="12"
				height="2"
				rx="1"
				fill="currentColor"
			/>
		</svg>
	);
};

export const whIcon = () => {
	return (
		<svg
			xmlns="http://www.w3.org/2000/svg"
			width="20"
			height="20"
			viewBox="0 0 64 64"
			role="img"
			aria-labelledby="whTitle whDesc"
		>
			<defs>
				<marker
					id="arrow"
					markerWidth="8"
					markerHeight="8"
					refX="4"
					refY="4"
					orient="auto"
					markerUnits="strokeWidth"
				>
					<path d="M0,0 L8,4 L0,8 Z" fill="currentColor" />
				</marker>
			</defs>

			<line
				x1="12"
				y1="32"
				x2="52"
				y2="32"
				stroke="currentColor"
				strokeWidth="3"
				markerStart="url(#arrow)"
				markerEnd="url(#arrow)"
			/>

			<line
				x1="32"
				y1="12"
				x2="32"
				y2="52"
				stroke="currentColor"
				strokeWidth="3"
				markerStart="url(#arrow)"
				markerEnd="url(#arrow)"
			/>
		</svg>
	);
};
