import React from 'react';
import PropTypes from 'prop-types';

import './styles.scss';

const propTypes = {
	isTop: PropTypes.bool,
	isBottom: PropTypes.bool,
};

const quizpressSeparator = ( {
	isTop = false,
	isBottom = false,
	suffix = '',
} ) => {
	const classNames = [ 'quizpress-separator' ];

	if ( isTop && isBottom ) {
		classNames.push( 'quizpress-separator--both' );
	} else {
		if ( isTop ) {
			classNames.push( 'quizpress-separator--top' );
		}
		if ( isBottom ) {
			classNames.push( 'quizpress-separator--bottom' );
		}
		if ( suffix ) {
			classNames.push( `quizpress-separator--${ suffix }` );
		}
	}

	return <div className={ classNames.join( ' ' ) }></div>;
};

export default quizpressSeparator;
quizpressSeparator.propTypes = propTypes;
