import React from 'react';
import { __ } from '@wordpress/i18n';
import GstText from '@QPComponents/GstText.js';

const OptIn = ( { type } ) => {
	let label;

	switch ( type ) {
		case 'date':
			label = __(
				'Here, users will find a date input field shown on the front end.',
				'quizpress'
			);
			break;
		case 'number':
			label = __(
				'With this question format, users get an input box on the front end restricted to numbers only.',
				'quizpress'
			);
			break;
		case 'short_answer':
			label = __(
				'In this question style, the front end will display a standard input box.',
				'quizpress'
			);
			break;
		case 'opt_in':
			label = __(
				'With this question format, the front end will display a checkbox, while the description field text functions as its label.',
				'quizpress'
			);
			break;
		case 'paragraph':
			label = __(
				'With this question format, users will find a regular textarea input box on the front end.',
				'quizpress'
			);
			break;
		case 'file_upload':
			label = __(
				'For this question, a file upload option will be visible to users on the front end.',
				'quizpress'
			);
			break;
		// case 'captcha':
		//     label = __('On the front end, users will see a Captcha field for this question.', 'quizpress');
		//     break;
		default:
			break;
	}

	return <GstText label={ label } />;
};
export default OptIn;
