import React from 'react';
import { __ } from '@wordpress/i18n';
import { Flex, Input, Text } from '@chakra-ui/react';
import { Field } from 'formik';

export default function ReadOnlyBlank( { ansName } ) {
	return (
		<Flex flexDirection="column" gap={ 4 }>
			<Flex flexDirection="column" gap={ 2 }>
				<Text margin={ 0 } className="quizpress-title">
					{ __( 'Answer title', 'quizpress' ) }
				</Text>
				<Field
					as={ Input }
					placeholder="Write answer title"
					type="text"
					name={ `${ ansName }.0.answer_title` }
					width="100%"
					className="quizpress-input"
				/>
				<Text margin={ 0 } className="quizpress-sub-title-muted">
					{ __(
						'Please make sure to use the {dash} variable in your question title to show the blanks in your question. You can use multiple {dash} variables in one question.',
						'quizpress'
					) }
				</Text>
			</Flex>

			<Flex flexDirection="column" gap={ 2 }>
				<Text margin={ 0 } className="quizpress-title">
					{ __( 'Answer', 'quizpress' ) }
				</Text>
				<Field
					as={ Input }
					name={ `${ ansName }.0.answer_content` }
					width="100%"
					type="text"
					placeholder="Write answers here"
					className="quizpress-input"
				/>
				<Text margin={ 0 } className="quizpress-sub-title-muted">
					{ __(
						'The question defines one answer per {dash} variable, with multiple answers separated by a vertical bar |. For instance, the possible answers to the question would be listed as: Apple | Banana | Orange.',
						'quizpress'
					) }
				</Text>
			</Flex>
		</Flex>
	);
}
