import React, { useEffect } from 'react';
import { __ } from '@wordpress/i18n';
import { Flex, Input, Text } from '@chakra-ui/react';
import { Field, useFormikContext } from 'formik';
import CustomSwitch from '@QPComponents/CustomSwitch';
import { getInitialAnswerValue } from '../../containers/BackendDashboard/pages/Quizzes/newQuiz/helper';

const TrueFalse = ( { ansName, ansVal, qstVal } ) => {
	const { setFieldValue } = useFormikContext();

	useEffect( () => {
		if (
			( trueVal && falseVal ) ||
			qstVal?.question_type !== 'true_false'
		) {
			return;
		}
		if ( ! Array.isArray( ansVal ) || ansVal.length !== 2 ) {
			setFieldValue( `${ ansName }`, [
				getInitialAnswerValue,
				getInitialAnswerValue,
			] );
		}
	}, [] );

	useEffect( () => {
		const qid = Number( qstVal?.question_id );
		setFieldValue( `${ ansName }.0.question_id`, qid );
		setFieldValue( `${ ansName }.1.question_id`, qid );
	}, [ qstVal?.question_id ] );

	const trueVal = ansVal[ 0 ]?.answer_title?.toLowerCase() === 'true';
	const falseVal = ansVal[ 1 ]?.answer_title?.toLowerCase() === 'false';

	useEffect( () => {
		if (
			( trueVal && falseVal ) ||
			qstVal?.question_type !== 'true_false'
		) {
			return;
		}
		setFieldValue( `${ ansName }.0.answer_title`, 'True' );
		setFieldValue( `${ ansName }.1.answer_title`, 'False' );
	}, [ trueVal, falseVal ] );

	const handleTrueChange = ( e ) => {
		const isChecked = e.target.checked;
		setFieldValue( `${ ansName }.0.is_correct`, isChecked );
		if ( isChecked ) {
			setFieldValue( `${ ansName }.1.is_correct`, false );
		}
	};

	const handleFalseChange = ( e ) => {
		const isChecked = e.target.checked;
		setFieldValue( `${ ansName }.1.is_correct`, isChecked );
		if ( isChecked ) {
			setFieldValue( `${ ansName }.0.is_correct`, false );
		}
	};

	return (
		<Flex direction="column" alignItems="center" gap={ 3 }>
			<Flex gap={ 3 } alignItems="center" width="100%">
				<Field
					as={ Input }
					name={ `${ ansName }.0.answer_title` }
					readOnly
					className="quizpress-input"
				/>
				<Flex
					gap={ 2 }
					alignItems="center"
					p={ 2 }
					border="1px solid var(--quizpress-border-color)"
					borderRadius="4px"
				>
					<Text fontWeight={ 500 } className="quizpress-title">
						{ __( 'Correct', 'quizpress' ) }
					</Text>
					<CustomSwitch
						name={ `${ ansName }.0.is_correct` }
						value={ Boolean( ansVal[ 0 ]?.is_correct ) }
						onChange={ handleTrueChange }
					/>
				</Flex>
			</Flex>

			<Flex gap={ 3 } alignItems="center" width="100%">
				<Field
					as={ Input }
					name={ `${ ansName }.1.answer_title` }
					readOnly
					className="quizpress-input"
				/>
				<Flex
					gap={ 2 }
					alignItems="center"
					p={ 2 }
					border="1px solid var(--quizpress-border-color)"
					borderRadius="4px"
				>
					<Text fontWeight={ 500 } className="quizpress-title">
						{ __( 'Correct', 'quizpress' ) }
					</Text>
					<CustomSwitch
						name={ `${ ansName }.1.is_correct` }
						value={ Boolean( ansVal[ 1 ]?.is_correct ) }
						onChange={ handleFalseChange }
					/>
				</Flex>
			</Flex>
		</Flex>
	);
};

export default TrueFalse;
