import React from 'react';
import PropTypes from 'prop-types';
import { Button, Flex, Box, Span, Text } from '@chakra-ui/react';
import { __ } from '@wordpress/i18n';
import { isPlainPermalink, is_admin } from '@QPUtils/helper';
import QPLabel from '@QPComponents/Labels/QPLabel';
import { primaryBtn } from '../../../assets/scss/chakra/recipe';
import CertificateFontsDownload from '@QPContainers/BackendDashboard/pages/Certificate/FontsDownload';

import './styles.scss';

const propTypes = {
	title: PropTypes.string,
	render: PropTypes.func,
	rightContent: PropTypes.func,
	leftContent: PropTypes.func,
};

const TopBar = ( {
	title = '',
	render = () => null,
	rightContent = () => null,
	middleContent = () => null,
	leftContent = () => null,
	topBarStyles = {},
} ) => {
	// if (!is_admin) return null;
	return (
		<React.Fragment>
			{ isPlainPermalink && (
				<Flex
					px={ 6 }
					py={ 4 }
					alignItems="center"
					gap={ 4 }
					width="100%"
					boxShadowColor={ 'var(--quizpress-shadow)' }
					bg="var(--quizpress-background)"
				>
					<Box
						bg="var(--quizpress-warning)"
						borderRadius="full"
						p="12px 14px"
					>
						<Span
							className="quizpress-icon quizpress-icon--circle-alert has-quizpress-blue-bg"
							_before={ { fontSize: '20px' } }
						/>
					</Box>
					<Text
						m={ 0 }
						dangerouslySetInnerHTML={ {
							__html: __(
								'Your permalink settings is set to <code>plain</code>. Please update your permalink settings. QuizPress works better with search engine friendly permalink.',
								'quizpress'
							),
						} }
					/>

					<Button
						{ ...primaryBtn }
						onClick={ () =>
							( window.location.href = `${ window.location.origin }/wp-admin/options-permalink.php` )
						}
					>
						{ __( 'Update permalink', 'quizpress' ) }
					</Button>
				</Flex>
			) }
			<Flex
				style={ topBarStyles }
				direction={ { base: 'column', md: 'row' } }
				justifyContent="space-between"
				align={ { base: 'flex-start', md: 'center' } }
				px={ 6 }
				py={ 4 }
				mb={ 6 }
				borderTop={
					isPlainPermalink
						? '1px solid var(--quizpress-border-color)'
						: 'none'
				}
				top="32px"
				borderBottomWidth="1px"
				borderColor="var(--quizpress-border-color)"
				boxShadowColor={ 'var(--quizpress-shadow)' }
				width="100%"
				bg="var(--quizpress-background)"
				position="sticky"
				zIndex={ 999 }
			>
				<Flex
					alignItems="center"
					gap={ 3 }
					flexWrap="wrap"
					width="fit-content"
				>
					{ render() }
					{ title ? (
						<QPLabel
							label={ title }
							fontSize="md"
							fontWeight="medium"
						/>
					) : null }
					{ leftContent() }
				</Flex>

				{ middleContent() }

				<Flex align="center" gap={ 2 }>
					{ rightContent() }
					{ /* <Button
					bg="transparent"
					borderWidth="1px"
					borderColor="var(--quizpress-border-color)"
					padding="5px"
					onClick={toggleTheme}
				>
					<span
						className={`easy-content-manager-icon easy-content-manager-icon--${isDark ? 'moon' : 'sun'}`}
					/>
				</Button> */ }
				</Flex>
			</Flex>
			<CertificateFontsDownload />
		</React.Fragment>
	);
};

TopBar.propTypes = propTypes;
export default TopBar;
