import React, { useEffect, useState } from 'react';
// import propTypes from 'prop-types';
import { __ } from '@wordpress/i18n';
import './styles.scss';
import Button from '@QPComponents/Button';
import { API, plugin_root_url, runUploader } from '@QPUtils/helper';

// const propTypes = {
//     name: PropTypes.string,
//     label: PropTypes.string,
//     value: PropTypes.number,
//     saveValueHandler: PropTypes.func,
//     imageSize: PropTypes.string,
//     supportedFile: PropTypes.string,
// };

export default function UploadImage( props ) {
	const {
		name = '',
		value = 0,
		label = __( 'Upload Image', 'quizpress' ),
		saveValueHandler = () => {},
		imageSize = '700x430 pixels',
		supportedFile = '.jpg, .jpeg, .gif, .png',
	} = props;

	const [ attachment, setAttachment ] = useState( {} );
	const [ fileType, setFileType ] = useState( '' );

	const uploadedAttachment = plugin_root_url + 'assets/images/importFile.svg';

	useEffect( () => {
		if ( value ) {
			API.get( `wp/v2/media/${ value }` ).then( ( res ) => {
				setAttachment( { url: res.data.source_url } );
				setFileType( res.data.mime_type );
			} );
		} else {
			setAttachment( {} );
			setFileType( '' );
		}
	}, [ value ] );

	const uploadImageHandler = ( e ) => {
		e.preventDefault();
		runUploader().then( ( res ) => {
			saveValueHandler( name, res.id );
			setAttachment( res );
			setFileType( res.mime_type );
		} );
	};

	const removeFeaturedImage = () => {
		saveValueHandler( name, 0 );
		setAttachment( {} );
		setFileType( '' );
	};

	const attachmentUrl = () => {
		if (
			fileType === 'application/pdf' ||
			fileType === 'application/docs' ||
			fileType === 'application/zip'
		) {
			return `${ uploadedAttachment }`;
		}
		return attachment.url;
	};

	return (
		<React.Fragment>
			<div className="quizpress-upload-image">
				<div className="quizpress-upload-image-container">
					<div className="quizpress-upload-image-container--wrap">
						{ Object.keys( attachment ).length === 0 ? (
							<div className="quizpress-upload-image-container--wrap--img">
								<div className="quizpress-upload-image-container--wrap--img--linear">
									<span className="quizpress-icon quizpress-icon--image" />
								</div>
								<span className="quizpress-title">
									{ __( 'Upload Image', 'quizpress' ) }
								</span>
							</div>
						) : (
							<>
								{ Object.keys( attachment ).length > 0 && (
									<div
										className="quizpress-upload-image-container--wrap--img--uploaded"
										style={ {
											backgroundImage: `url(${ attachmentUrl() })`,
											backgroundRepeat: 'no-repeat',
											backgroundSize: 'contain',
											backgroundPosition: 'center center',
										} }
									/>
								) }
							</>
						) }
					</div>

					<div className="quizpress-upload-image-container--details">
						<span className="quizpress-upload-image-container--details--label">
							{ label }
						</span>
						<div className="quizpress-upload-image-container--details--info">
							<p className="quizpress-upload-image-container--details--info--support">
								<span>
									{ __( 'File Support:', 'quizpress' ) }
								</span>{ ' ' }
								{ supportedFile }.
							</p>
							<p className="quizpress-upload-image-container--details--info--size">
								<span>
									{ __( 'Recommended size:', 'quizpress' ) }
								</span>{ ' ' }
								{ imageSize }
							</p>
						</div>
						<Button
							type="button"
							onClick={ ( e ) => uploadImageHandler( e ) }
							preset="clear"
							size="sm"
							icon={
								<span className="quizpress-icon quizpress-icon--upload" />
							}
							label={
								Object.keys( attachment ).length > 0
									? __( 'Change', 'quizpress' )
									: __( 'Upload', 'quizpress' )
							}
						/>
					</div>
				</div>

				{ Object.keys( attachment ).length > 0 && (
					<Button
						onClick={ removeFeaturedImage }
						type="button"
						icon={
							<span className="quizpress-icon quizpress-icon--delete"></span>
						}
						className="quizpress-btn-delete"
						suffix="delete"
						preset="transparent"
					/>
				) }
			</div>
		</React.Fragment>
	);
}

// UploadImage.propTypes = propTypes;
