import React from 'react';
import {
	VStack,
	Box,
	Flex,
	Text,
	Input,
	Textarea,
	Button,
} from '@chakra-ui/react';
import { Field, useFormikContext } from 'formik';
import { __ } from '@wordpress/i18n';
import { generateSlug, useQuery } from '@QPUtils/helper';

const AddCategoryFormInner = () => {
	const { setFieldValue } = useFormikContext();
	const location = useQuery();
	const id = location.get( 'id' );

	return (
		<VStack
			display="flex"
			flexDirection="column"
			gap={ 6 }
			margin={ '0px' }
		>
			<Flex
				as="label"
				flexDirection={ 'column' }
				gap={ '6px' }
				width="100%"
			>
				<Text
					fontSize="0.87rem"
					fontWeight="500"
					margin={ '0px' }
					color={ 'var(--quizpress-font-color)' }
				>
					{ __( 'Name', 'quizpress' ) }
				</Text>
				<Field
					name="name"
					as={ Input }
					type="text"
					placeholder={ __( 'Kodezen Quiz', 'quizpress' ) }
					className="quizpress-input"
					onBlur={ ( e ) =>
						setFieldValue( 'slug', generateSlug( e.target.value ) )
					}
				/>
				<Text
					color={ 'var(--quizpress-warn-muted)' }
					margin={ '0px' }
					fontSize={ '0.75rem' }
				>
					{ __(
						'The name is how it appears on your site.',
						'quizpress'
					) }
				</Text>
			</Flex>

			<Flex flexDirection={ 'column' } gap={ '6px' } width="100%">
				<Text
					fontSize="0.87rem"
					fontWeight="500"
					as="label"
					color={ 'var(--quizpress-font-color)' }
				>
					{ __( 'Slug', 'quizpress' ) }
				</Text>

				<Field
					name="slug"
					as={ Input }
					type="text"
					placeholder={ __( 'KZ limited', 'quizpress' ) }
					className="quizpress-input"
				/>
				<Text
					color={ 'var(--quizpress-warn-muted)' }
					margin={ '0px' }
					fontSize={ '0.75rem' }
				>
					{ __(
						'The “slug” is the URL-friendly version of the name.',
						'quizpress'
					) }
				</Text>
			</Flex>

			<Flex flexDirection={ 'column' } gap={ '6px' } width="100%">
				<Text
					fontSize="0.87rem"
					fontWeight="500"
					as="label"
					color={ 'var(--quizpress-font-color)' }
				>
					{ __( 'Description', 'quizpress' ) }
				</Text>

				<Field
					name="description"
					as={ Textarea }
					type="text"
					placeholder={ __( 'Content', 'quizpress' ) }
					className="quizpress-textarea"
				/>
			</Flex>
		</VStack>
	);
};

export default AddCategoryFormInner;
