import React from 'react';
import { __ } from '@wordpress/i18n';
import TopBar from '@QPComponents/TopBar';
import QPLabel from '@QPComponents/Labels/QPLabel';
import { Button } from '@chakra-ui/react';
import { primaryBtn } from '../../../../../assets/scss/chakra/recipe';
import { admin_url } from '@QPUtils/helper';
import CertificateTable from './CertificateTable';

const Certificate = () => {
	return (
		<>
			<TopBar
				leftContent={ () => (
					<>
						<span className="quizpress-topbar-logo quizpress-icon quizpress-icon--quizpress" />
						<span className="quizpress-icon quizpress-icon--angle-right quizpress-muted" />
						<QPLabel
							as="h2"
							color="#4F46E5"
							type="subtitle"
							fontWeight="medium"
							label={ __( 'Certificate', 'quizpress' ) }
						/>
					</>
				) }
				rightContent={ () => (
					<>
						<Button
							{ ...primaryBtn }
							onClick={ () =>
								window.open(
									`${ admin_url }post-new.php?post_type=qp_certificate`,
									'_blank'
								)
							}
						>
							<span className="quizpress-icon quizpress-icon--plus has-quizpress-blue-bg" />
							{ __( 'Create New', 'quizpress' ) }
						</Button>
					</>
				) }
			/>
			<CertificateTable />
		</>
	);
};

export default Certificate;
