import React, { useMemo } from 'react';
import { __ } from '@wordpress/i18n';
import { Box, Heading, Span } from '@chakra-ui/react';
import { useNavigate } from 'react-router-dom';
import { route_path } from '@QPUtils/helper';
import ListTable from '@QPComponents/ListTable';

export default function TopQuizzes( { topQuizzes = [] } ) {
	const navigate = useNavigate();

	const columns = [
		{
			name: __( 'Title', 'quizpress' ),
			cell: ( row ) => {
				return (
					<div className="quizpress-table-title-wrap">
						{ row?.post_title }
					</div>
				);
			},
		},
		{
			name: __( 'Avg Score', 'quizpress' ),
			cell: ( row ) => <span>{ row?.avg_score }</span>,
		},
		{
			name: __( 'Attempts', 'quizpress' ),
			cell: ( row ) => <span>{ row?.attempts }</span>,
		},
		{
			name: __( 'Action', 'quizpress' ),
			cell: ( row ) => {
				return (
					<Span
						color="var(--quizpress-primary)"
						cursor="pointer"
						onClick={ () => {
							navigate(
								`${ route_path }admin.php?page=quizpress-quizzes&action=leaderboard&id=${ row?.quiz_id }`
							);
						} }
					>
						{ __( 'View Analytics', 'quizpress' ) }
					</Span>
				);
			},
		},
	];

	const subHeaderComponentMemo = useMemo( () => {
		return (
			<>
				<div className="quizpress-table__sub-header-left">
					<Heading
						fontSize="1.125rem"
						fontWeight="500"
						lineHeight="24px"
						m={ 0 }
						color="var(--quizpress-font-color)"
					>
						{ __( 'Top Quizzes', 'quizpress' ) }
					</Heading>
				</div>
				<div className="quizpress-table-sub-header-actions-right"></div>
			</>
		);
	}, [] );

	return (
		<Box width="100%" gap="0px !important">
			<ListTable
				columns={ columns }
				data={ topQuizzes ?? [] }
				showSubHeader={ true }
				subHeaderComponent={ subHeaderComponentMemo }
				isRowSelectable={ false }
				showColumnFilter={ false }
				noDataText={ __(
					'Please, create Quiz to see the available list here.',
					'quizpress'
				) }
				getSelectRowValue={ ( selectedRow ) => {} }
				showPagination={ false }
				dataFetchingStatus={ false }
				suffix="dashboard-top-quizzes-table"
			/>
		</Box>
	);
}
