import React, { useMemo } from 'react';
import { __ } from '@wordpress/i18n';
import { Box, Heading, Span } from '@chakra-ui/react';
import ListTable from '@QPComponents/ListTable';

export default function TopUsers( { topUsers = [] } ) {
	const columns = [
		{
			name: __( 'Name', 'quizpress' ),
			cell: ( row ) => {
				return (
					<div className="quizpress-table-title-wrap">
						{ row?.display_name }
					</div>
				);
			},
		},
		{
			name: __( 'Total Attempts', 'quizpress' ),
			cell: ( row ) => <span>{ row?.attempts }</span>,
		},
		{
			name: __( 'Score', 'quizpress' ),
			cell: ( row ) => <span>{ row?.total_score }</span>,
		},
		{
			name: __( 'Action', 'quizpress' ),
			cell: ( row ) => {
				return (
					<Span
						onClick={ () => {
							// navigate(`${admin_url}user-edit.php?user_id=${row?.user_id}`);
						} }
					>
						{ __( 'View Profile', 'quizpress' ) }
					</Span>
				);
			},
		},
	];

	const subHeaderComponentMemo = useMemo( () => {
		return (
			<>
				<div className="quizpress-table__sub-header-left">
					<Heading
						fontSize="1.125rem"
						fontWeight="500"
						lineHeight="24px"
						m={ 0 }
						color="var(--quizpress-font-color)"
					>
						{ __( 'Leaderboard', 'quizpress' ) }
					</Heading>
				</div>
				<div className="quizpress-table-sub-header-actions-right"></div>
			</>
		);
	}, [] );

	return (
		<Box width="100%" gap="0px !important">
			<ListTable
				columns={ columns }
				data={ topUsers ?? [] }
				showSubHeader={ true }
				subHeaderComponent={ subHeaderComponentMemo }
				isRowSelectable={ false }
				showColumnFilter={ false }
				noDataText={ __(
					'Please, create Quiz to see the available list here.',
					'quizpress'
				) }
				getSelectRowValue={ ( selectedRow ) => {} }
				showPagination={ false }
				dataFetchingStatus={ false }
				suffix="dashboard-leaderboard-table"
			/>
		</Box>
	);
}
