import React, { useEffect } from 'react';
import { __ } from '@wordpress/i18n';
import { Flex, Text } from '@chakra-ui/react';
import { useDispatch, useSelector } from 'react-redux';
import { getAnalytics } from '@QPRedux/Slices/dashboardSilce/dashboardSilce';
import TopUsers from './TopUsers';
import { capitalizeFirstLetter } from '@QPUtils/helper';
import { Heading } from '@chakra-ui/react';
import TopQuizzes from './TopQuizzes';
import TopBar from '@QPComponents/TopBar';
import QPLabel from '@QPComponents/Labels/QPLabel';

const Dashboard = () => {
	const { data: analytics } = useSelector( ( state ) => state.analytics );
	const dispatch = useDispatch();

	useEffect( () => {
		dispatch( getAnalytics() ).then( ( res ) => {
			// setData(res.payload);
		} );
	}, [] );

	const renderCard = ( { title, count } ) => (
		<Flex
			direction="column"
			gap={ 2 }
			alignItems="flex-start"
			bg="var(--quizpress-background)"
			borderRadius="4px"
			p="4"
			width="180px"
		>
			<Text
				fontSize="1rem"
				color="var(--quizpress-font-color)"
				fontWeight="600"
				m={ 0 }
			>
				{ __( `${ title ?? '' }`, 'quizpress' ) }
			</Text>
			<Text
				fontSize="0.87rem"
				color="var(--quizpress-font-color)"
				fontWeight="500"
				m={ 0 }
			>
				{ __( `${ count ?? 0 }`, 'quizpress' ) }
			</Text>
		</Flex>
	);

	return (
		<>
			<TopBar
				leftContent={ () => (
					<>
						<span className="quizpress-topbar-logo quizpress-icon quizpress-icon--quizpress" />
						<span className="quizpress-icon quizpress-icon--angle-right" />
						<QPLabel
							as="h2"
							color="#4F46E5"
							type="subtitle"
							fontWeight="medium"
							label={ __( `Dashboard`, 'quizpress' ) }
						/>
					</>
				) }
			/>
			<Flex
				gap={ 6 }
				flexDirection="column"
				className="quizpress-page-content"
			>
				<Flex
					className="quizpress-page--dashboard"
					bg="transparent"
					p="0"
				>
					<Heading className="quizpress-heading" margin="0px">
						{ __( 'Dashboard', 'quizpress' ) }
					</Heading>
					<Flex gap={ 4 } flexWrap="wrap">
						{ analytics?.quiz_type_breakdown &&
							renderCard( {
								title: capitalizeFirstLetter(
									analytics?.quiz_type_breakdown[ 0 ]
										?.quiz_type ?? 'Quiz'
								),
								count: analytics?.quiz_type_breakdown[ 0 ]
									?.total,
							} ) }
						{ renderCard( {
							title: __( 'Average Attempts', 'quizpress' ),
							count: analytics?.summary
								?.average_attempts_per_quiz,
						} ) }
						{ renderCard( {
							title: __( 'Average Score', 'quizpress' ),
							count: analytics?.summary?.average_score,
						} ) }
						{ renderCard( {
							title: __( 'Total Attempts', 'quizpress' ),
							count: analytics?.summary?.total_attempts,
						} ) }
						{ renderCard( {
							title: __( 'Total Quizzes', 'quizpress' ),
							count: analytics?.summary?.total_quizzes,
						} ) }
						{ renderCard( {
							title: __( 'Total Users', 'quizpress' ),
							count: analytics?.summary?.total_users,
						} ) }
					</Flex>
				</Flex>
				<TopQuizzes topQuizzes={ analytics?.top_quizzes } />
				<TopUsers topUsers={ analytics?.top_users } />
			</Flex>
		</>
	);
};

export default Dashboard;
