import React, { useState } from 'react';
import { __ } from '@wordpress/i18n';
import { Collapsible, Flex, Input, Span, Switch, Text } from '@chakra-ui/react';
import { Field, useFormikContext } from 'formik';
import QPTooltip from '@QPComponents/QPTooltip';
import CustomSwitch from '@QPComponents/CustomSwitch';

const QuestionSettings = () => {
	const { values, setFieldValue } = useFormikContext();
	const [ isQSOpen, setIsQSOpen ] = useState( true );
	return (
		<Collapsible.Root display="flex" flexDirection="column" defaultOpen>
			<Collapsible.Trigger
				display="flex"
				flexDirection="row"
				justifyContent="space-between"
				alignItems="center"
				py={ 3 }
				px={ 4 }
				border="1px solid var(--quizpress-border-color)"
				borderRadius={ isQSOpen ? '4px 4px 0 0' : '4px' }
				cursor="pointer"
				onClick={ () => setIsQSOpen( ! isQSOpen ) }
			>
				<Text className="quizpress-title">
					{ __( 'Question Settings', 'quizpress' ) }
				</Text>
				{ isQSOpen ? (
					<Span className="quizpress-icon quizpress-icon--arrow-up" />
				) : (
					<Span className="quizpress-icon quizpress-icon--arrow-down" />
				) }
			</Collapsible.Trigger>
			<Collapsible.Content>
				<Flex
					direction="column"
					gap={ 3 }
					p={ 4 }
					borderLeft="1px solid var(--quizpress-border-color)"
					borderRight="1px solid var(--quizpress-border-color)"
					borderBottom="1px solid var(--quizpress-border-color)"
					borderRadius="0 0 4px 4px"
				>
					<Flex justifyContent="space-between" alignItems="center">
						<Flex gap={ 2 } alignItems="center">
							<Text className="quizpress-title">
								{ __( 'Answer required', 'quizpress' ) }
							</Text>
							<QPTooltip
								type="info"
								position="bottom"
								width="250px"
								noWrap={ false }
								content={ __(
									'If enable required to answer.',
									'quizpress'
								) }
							/>
						</Flex>
						<CustomSwitch
							name="question_settings.answer_required"
							value={ values?.question_settings.answer_required }
							onChange={ ( e ) =>
								setFieldValue(
									'question_settings.answer_required',
									e.target.checked
								)
							}
						/>
					</Flex>
					<Flex justifyContent="space-between" alignItems="center">
						<Flex gap={ 2 } alignItems="center">
							<Text className="quizpress-title">
								{ __( 'Random answer', 'quizpress' ) }
							</Text>
							<QPTooltip
								type="info"
								position="top"
								width="250px"
								noWrap={ false }
								content={ __(
									'If enable answer will be randomized.',
									'quizpress'
								) }
							/>
						</Flex>
						<CustomSwitch
							name="question_settings.random_answer"
							value={ values?.question_settings.random_answer }
							onChange={ ( e ) =>
								setFieldValue(
									'question_settings.random_answer',
									e.target.checked
								)
							}
						/>
					</Flex>
					<Flex justifyContent="space-between" alignItems="center">
						<Flex gap={ 2 } alignItems="center">
							<Text className="quizpress-title">
								{ __( 'Display points', 'quizpress' ) }
							</Text>
							<QPTooltip
								type="info"
								position="top"
								width="250px"
								noWrap={ false }
								content={ __(
									'If the enable point will display.',
									'quizpress'
								) }
							/>
						</Flex>
						<CustomSwitch
							name="question_settings.display_points"
							value={ values?.question_settings.display_points }
							onChange={ ( e ) =>
								setFieldValue(
									'question_settings.display_points',
									e.target.checked
								)
							}
						/>
					</Flex>
					<Flex justifyContent="space-between" alignItems="center">
						<Flex gap={ 2 } alignItems="center">
							<Text className="quizpress-title">
								{ __( 'Question Point', 'quizpress' ) }
							</Text>
							<QPTooltip
								type="info"
								position="top"
								width="250px"
								noWrap={ false }
								content={ __(
									'Enter a value for question point.',
									'quizpress'
								) }
							/>
						</Flex>
						<Field
							as={ Input }
							name={ `question_score` }
							type="number"
							className="quizpress-input"
							width="40%"
						/>
					</Flex>
					<Flex justifyContent="space-between" alignItems="center">
						<Flex gap={ 2 } alignItems="center">
							<Text className="quizpress-title">
								{ __( 'Negative Marking', 'quizpress' ) }
							</Text>
							<QPTooltip
								type="info"
								position="top"
								width="250px"
								noWrap={ false }
								content={ __(
									'Enter a value to deduct points for wrong quiz answers. Use 0 to avoid marking.',
									'quizpress'
								) }
							/>
						</Flex>
						<Field
							as={ Input }
							name="question_negative_score"
							type="number"
							className="quizpress-input"
							width="40%"
						/>
					</Flex>
				</Flex>
			</Collapsible.Content>
		</Collapsible.Root>
	);
};

export default QuestionSettings;
