import { isArray } from '@QPUtils/helper';

export const getInitialAnswerValue = {
	quiz_id: 0,
	answer_points: 1,
	question_id: '',
	answer_title: '',
	answer_content: '',
	is_correct: false,
	image_id: 0,
	view_format: '',
	answer_order: 0,
};

export const getInitialValue = ( id = null, data = null ) => {
	if ( id && data ) {
		data = data.find(
			( item ) => Number( item.question_id ) === Number( id )
		);
		return {
			...data,
			answers: isArray( data?.answers )
				? data.answers
				: [ getInitialAnswerValue ],
		};
	}

	return {
		question_id: null,
		question_title: '',
		question_name: '',
		question_content: '',
		question_explanation: '',
		question_status: 'publish',
		question_level: '',
		question_type: 'single_choice',
		answer_type: 'plain_text',
		question_score: 1,
		question_negative_score: 0,
		question_settings: {
			display_points: false,
			answer_required: true,
			random_answer: true,
		},
		question_order: 0,
		answers: [],
	};
};
