import React, { useEffect, useState } from 'react';
import { __ } from '@wordpress/i18n';
import { FormikWizard } from 'formik-wizard-form';
import { quizFormInitialValues } from './helper';
import FirstStep from './steps/FirstStep';
import SecondStep from './steps/SecondStep';
import ThirdStep from './steps/ThirdStep';
import FormikWizardContext from './Context/FormikWizardContext';
import { useDispatch, useSelector } from 'react-redux';
import {
	createQuiz,
	getQuiz,
	updateQuiz,
} from '@QPRedux/Slices/quizSlice/quizSlice';
import { useNavigate } from 'react-router-dom';
import { route_path, useQuery } from '@QPUtils/helper';
import QuestionImport from './quizPages/QuestionImport';
import QuizEditorTopBar from './QuizEditorTopBar';
import Preloader from '@QPComponents/Loader/Preloader';
import { Box } from '@chakra-ui/react';

const CreateQuiz = ( { action, id } ) => {
	const { data } = useSelector( ( state ) => state.quizzes );
	const settings = useSelector( ( state ) => state.settings );

	const [ loading, setLoading ] = useState( false );

	const dispatch = useDispatch();
	const navigate = useNavigate();
	const location = useQuery();

	const currentPath = location.get( 'path' );

	function renderActiveStepIndex() {
		switch ( currentPath ) {
			case 'name':
				return 0;
			case 'questions':
				return 1;
			case 'settings':
				return 2;

			default:
				return 0;
		}
	}

	useEffect( () => {
		if ( id && ! data.length ) {
			setLoading( true );
			dispatch( getQuiz( { ID: id, isEditable: true } ) ).finally( () =>
				setLoading( false )
			);
		}
	}, [ id, data ] );

	const onSubmitFormHandler = ( values, { setSubmitting } ) => {
		setSubmitting( true );

		const { questions: submittedQuestions, ...restQuiz } = values;

		if ( ! restQuiz?.id ) {
			dispatch( createQuiz( restQuiz ) )
				.then( ( { payload } ) => {
					navigate(
						`${ route_path }admin.php?page=quizpress-quizzes&action=edit&id=${ payload?.id }&path=questions`
					);
				} )
				.finally( () => {
					setSubmitting( false );
				} );
			return;
		}

		dispatch(
			updateQuiz( {
				params: restQuiz,
				questions: submittedQuestions,
			} )
		).finally( () => {
			setSubmitting( false );
		} );
	};

	const steps = [
		{ title: __( 'Name', 'quizpress' ), component: FirstStep },
		{ title: __( 'Questions', 'quizpress' ), component: SecondStep },
		{ title: __( 'Settings', 'quizpress' ), component: ThirdStep },
	];
	return (
		<FormikWizard
			enableReinitialize={ true }
			initialValues={ quizFormInitialValues( id, data, settings ) }
			onSubmit={ onSubmitFormHandler }
			validateOnNext
			activeStepIndex={ renderActiveStepIndex() }
			steps={ steps }
		>
			{ ( {
				currentStepIndex,
				renderComponent,
				handlePrev,
				handleNext,
				isNextDisabled,
				isPrevDisabled,
				isLastStep,
			} ) => {
				return (
					<FormikWizardContext.Provider
						value={ {
							currentStepIndex,
							renderComponent,
							handlePrev,
							handleNext,
							isNextDisabled,
							isPrevDisabled,
							isLastStep,
						} }
					>
						<QuizEditorTopBar id={ id } steps={ steps } />
						{ /* <AutoSave delay={500}/>  */ }
						{ loading ? (
							<Box mt={ 32 }>
								<Preloader />
							</Box>
						) : (
							renderComponent()
						) }
					</FormikWizardContext.Provider>
				);
			} }
		</FormikWizard>
	);
};

export default CreateQuiz;
