import { __, sprintf } from '@wordpress/i18n';
import { Box, Text, Flex, Span } from '@chakra-ui/react';

const OverlayQst = ( { question } ) => {
	return (
		<Flex
			border="1px solid"
			borderColor="gray.200"
			opacity={ 0.7 }
			transform="rotate(1deg)"
			pointerEvents="none"
			bg="var(--quizpress-background)"
			width="full"
			p={ 4 }
			borderRadius="4px"
			boxShadow="var(--quizpress-shadow)"
			alignItems="center"
			justifyContent="space-between"
		>
			<Flex gap={ 3 } alignItems="center">
				<Span className="quizpress-icon quizpress-icon--move" />
				<Flex direction="column" gap={ 1 }>
					<Text
						fontSize="1rem"
						fontWeight="600"
						m={ 0 }
						color="var(--quizpress-primary)"
					>
						{ question.question_title
							? sprintf(
									//translate: %s question title
									__( '%s', 'quizpress' ),
									question.question_title
							  )
							: __( 'Untitled Question', 'quizpress' ) }
					</Text>
					{ /* category */ }
					{ /* <Text fontSize="0.875rem" m={0} color="var(--quizpress-warn-muted)">
                            {__(`Category: ${category}`, 'quizpress')}
                        </Text> */ }
				</Flex>
			</Flex>

			<Span className="quizpress-icon quizpress-icon--menu-horizontal" />
		</Flex>
	);
};

export default OverlayQst;
