import React, { useState } from 'react';
import { __ } from '@wordpress/i18n';
import {
	Box,
	Button,
	Circle,
	Flex,
	Input,
	Span,
	Text,
	Textarea,
} from '@chakra-ui/react';
import { primaryBtn } from '../../../../../../../assets/scss/chakra/recipe';
import QuizPressCheckbox from '@QPComponents/QuizPressCheckbox';
import { Field, useFormikContext } from 'formik';
import Select from 'react-select';
import QuestionSettings from './QuestionSettings';
import QuestionImport from './QuestionImport';
import SingleChoiceText from '../../../../../../components/RenderAnswers/SingleChoiceText';
import { questionTypeOptions } from '@QPUtils/helper';

const answerTypeOptions = [
	{ label: __( 'Plain Text', 'quizpress' ), value: 'plain_text' },
	{ label: __( 'Rich Text', 'quizpress' ), value: 'rich_text' },
	{ label: __( 'Image', 'quizpress' ), value: 'image' },
	{ label: __( 'Image & Text', 'quizpress' ), value: 'image_and_text' },
];

const Page = () => {
	const { values, setFieldValue } = useFormikContext();
	const [ isPageOpen, setIsPageOpen ] = useState( false );
	const [ isQuestionOpen, setIsQuestionOpen ] = useState( false );
	const [ isModalOpen, setIsModalOpen ] = useState( false );

	//todo: remove this after redux and category implementation
	const [ selectedQuestion, setSelectedQuestion ] = useState( '' );
	const [ selectedAnswer, setSelectedAnswer ] = useState( '' );

	const handleAddQuestion = ( e ) => {
		e.stopPropagation();
		// do something
	};

	const category = 'World cup quiz'; //todo: remove this after redux and category implementation

	const renderSwitchQuestionType = ( questionType ) => {
		switch ( questionType ) {
			case 'single_choice':
				if ( selectedAnswer === 'plain_text' ) {
					return <SingleChoiceText />;
				}
				if ( selectedAnswer === 'rich_text' ) {
					return <SingleChoiceText />;
				}
				if ( selectedAnswer === 'image' ) {
					return <SingleChoiceText />;
				}
				if ( selectedAnswer === 'image_and_text' ) {
					return <SingleChoiceText />;
				}
			default:
		}
	};

	return (
		<Flex direction="column" width="100%">
			<Flex
				width="100%"
				direction="column"
				onClick={ ( e ) => {
					e.stopPropagation();
					setIsPageOpen( ! isPageOpen );
				} }
				cursor="pointer"
			>
				<Flex
					width="100%"
					bg="var(--quizpress-background)"
					p={ 6 }
					borderRadius="4px"
					justifyContent="space-between"
				>
					<Flex gap={ 3 } alignItems="center">
						<Button variant="ghost">
							<Span className="quizpress-icon quizpress-icon--move" />
						</Button>
						<Text
							fontSize="1.3rem"
							fontWeight="500"
							m={ 0 }
							color="var(--quizpress-font-color)"
						>
							{ /* todo: update this title based on page name after redux and implementation */ }
							{ __( 'Page 1', 'quizpress' ) }
						</Text>
					</Flex>

					<Flex gap={ 3 } alignItems="center">
						<Button variant="ghost">
							<Span
								cursor="pointer"
								className="quizpress-icon quizpress-icon--square-pen quizpress-primary"
							/>
						</Button>
						<Button
							{ ...primaryBtn }
							onClick={ ( e ) => {
								e.stopPropagation();
								setIsModalOpen( true );
							} }
						>
							<Span className="quizpress-icon quizpress-icon--import has-quizpress-blue-bg" />
							{ __( 'Import Questions', 'quizpress' ) }
						</Button>
						<Button
							{ ...primaryBtn }
							onClick={ ( e ) => handleAddQuestion( e ) }
						>
							<Span className="quizpress-icon quizpress-icon--plus has-quizpress-blue-bg" />
							{ __( 'Add Question', 'quizpress' ) }
						</Button>
					</Flex>
				</Flex>
			</Flex>

			{ isPageOpen && (
				<Flex
					direction="column"
					gap={ 4 }
					bg="var(--quizpress-body-background)"
					padding="36px 24px"
					borderLeftWidth="1px"
					borderRightWidth={ '1px' }
					borderBottomWidth={ '1px' }
					borderBottomRadius="4px"
					borderColor="var(--quizpress-border-color)"
				>
					<QuizPressCheckbox
						title={ __( 'Select All', 'quizpress' ) }
						fontWeight="500"
					/>

					{ /* todo: update this content based on quiz after redux and implementation */ }
					<Flex gap={ 3 }>
						<Box p={ 0 } mt={ 9 }>
							<QuizPressCheckbox />
						</Box>
					</Flex>
				</Flex>
			) }

			<QuestionImport
				isOpen={ isModalOpen }
				onRequestClose={ () => setIsModalOpen( false ) }
			/>
		</Flex>
	);
};

export default Page;
