import React, { useContext } from 'react';
import { __ } from '@wordpress/i18n';
import { Button, Flex, Span, Text } from '@chakra-ui/react';
import {
	outlineBtn,
	primaryBtn,
} from '../../../../../../../assets/scss/chakra/recipe';
import FormikWizardContext from '../Context/FormikWizardContext';
import Page from './Page';

const QuizPages = () => {
	const { handleNext, handlePrev } = useContext( FormikWizardContext );

	return (
		<Flex className="quizpress-page-content" direction="column" gap={ 6 }>
			<Page />

			<Flex gap={ 4 } alignItems="center" justifyContent="flex-end">
				<Button
					{ ...outlineBtn }
					bg="var(--quizpress-background)"
					onClick={ handlePrev }
				>
					<Span className="quizpress-icon quizpress-icon--angle-left quizpress-primary" />
				</Button>
				<Button { ...primaryBtn }>
					<Span className="quizpress-icon quizpress-icon--plus has-quizpress-blue-bg" />
					{ __( 'Create New Page', 'quizpress' ) }
				</Button>
				<Button { ...primaryBtn } onClick={ handleNext }>
					{ __( 'Save & Continue', 'quizpress' ) }
				</Button>
			</Flex>
		</Flex>
	);
};

export default QuizPages;
