import React from 'react';
import { __ } from '@wordpress/i18n';
import { Box, Flex, Input, RadioCard, Text, Textarea } from '@chakra-ui/react';
import { Field, useFormikContext } from 'formik';
import Select from 'react-select';
import CustomSwitch from '@QPComponents/CustomSwitch';

import './styles/thirdStep.scss';

const radioItems = [
	{
		value: 'default',
		title: __( 'Default', 'quizpress' ),
		subtitle: __(
			'Answers are shown after the quiz is finished',
			'quizpress'
		),
	},
	{
		value: 'retry_mode',
		title: __( 'Retry Mode', 'quizpress' ),
		subtitle: __( 'Unlimited attempts on each question.', 'quizpress' ),
	},
];

const questionOrderOptions = [
	{ label: __( 'Random', 'quizpress' ), value: 'random' },
	{ label: __( 'Ascending', 'quizpress' ), value: 'asc' },
	{ label: __( 'Descending', 'quizpress' ), value: 'desc' },
];

const ThirdStep = () => {
	const { values, setFieldValue } = useFormikContext();
	const isShowScoreSettings =
		values?.meta?.quizpress_quiz_type !== 'survey' &&
		values?.meta?.quizpress_quiz_type !== 'poll';

	return (
		<Flex className="quizpress-page-content" direction="column" gap={ 9 }>
			<Flex
				className="quizpress-quiz-settings"
				bg="var(--quizpress-background)"
				p={ 6 }
				borderRadius="4px"
				direction="column"
				gap={ 6 }
			>
				<h1 className="quizpress-heading">
					{ __( 'Settings', 'quizpress' ) }
				</h1>

				{ isShowScoreSettings && (
					<Flex
						as="label"
						gap="8px"
						width="100%"
						justifyContent="space-between"
						alignItems="center"
					>
						<Flex flexDirection="column" gap="4px">
							<Text className="quizpress-title" margin={ 0 }>
								{ __( 'Hide question number', 'quizpress' ) }
							</Text>
							<Text
								color="var(--quizpress-warn-muted)"
								fontSize="0.75rem"
								margin={ 0 }
							>
								{ __(
									'Show/hide question number during attempt.',
									'quizpress'
								) }
							</Text>
						</Flex>

						<CustomSwitch
							name="meta.quizpress_quiz_hide_question_number"
							value={
								values?.meta.quizpress_quiz_hide_question_number
							}
							onChange={ ( e ) =>
								setFieldValue(
									'meta.quizpress_quiz_hide_question_number',
									e.target.checked
								)
							}
						/>
					</Flex>
				) }

				<Flex
					as="label"
					gap="8px"
					width="100%"
					justifyContent="space-between"
					alignItems="center"
				>
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __( 'Hide quiz time', 'quizpress' ) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __( 'Show/hide quiz time', 'quizpress' ) }
						</Text>
					</Flex>

					<CustomSwitch
						name="meta.quizpress_quiz_hide_quiz_time"
						value={ values?.meta.quizpress_quiz_hide_quiz_time }
						onChange={ ( e ) =>
							setFieldValue(
								'meta.quizpress_quiz_hide_quiz_time',
								e.target.checked
							)
						}
					/>
				</Flex>

				<Flex
					as="label"
					gap="8px"
					width="100%"
					justifyContent="space-between"
					alignItems="center"
				>
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __(
								'Force All Questions Required',
								'quizpress'
							) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __(
								'Forcefully require all questions to be answered.',
								'quizpress'
							) }
						</Text>
					</Flex>

					<CustomSwitch
						name="meta.quizpress_quiz_force_all_questions_required"
						value={
							values?.meta
								.quizpress_quiz_force_all_questions_required
						}
						onChange={ ( e ) =>
							setFieldValue(
								'meta.quizpress_quiz_force_all_questions_required',
								e.target.checked
							)
						}
					/>
				</Flex>

				<Flex
					as="label"
					gap="8px"
					width="100%"
					justifyContent="space-between"
					alignItems="center"
				>
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __( 'Quiz auto start', 'quizpress' ) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __(
								'Auto start the quiz when the page loads',
								'quizpress'
							) }
						</Text>
					</Flex>

					<CustomSwitch
						name="meta.quizpress_quiz_auto_start"
						value={ values?.meta.quizpress_quiz_auto_start }
						onChange={ ( e ) =>
							setFieldValue(
								'meta.quizpress_quiz_auto_start',
								e.target.checked
							)
						}
					/>
				</Flex>

				<Flex
					as="label"
					gap="8px"
					width="100%"
					justifyContent="space-between"
					alignItems="center"
				>
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __( 'Enable Question Explanation', 'quizpress' ) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __(
								'Show/hide question explanation after attempt.',
								'quizpress'
							) }
						</Text>
					</Flex>

					<CustomSwitch
						name="meta.quizpress_quiz_explanation_enabled"
						value={
							values?.meta.quizpress_quiz_explanation_enabled
						}
						onChange={ ( e ) =>
							setFieldValue(
								'meta.quizpress_quiz_explanation_enabled',
								e.target.checked
							)
						}
					/>
				</Flex>

				<Flex
					justifyContent="space-between"
					width="100%"
					paddingTop={ 6 }
					borderTop="1px solid var(--quizpress-border-color)"
				>
					<Flex flexDirection="column" gap={ 2 }>
						<Text className="quizpress-title" margin={ 0 }>
							{ __( 'Time Limit', 'quizpress' ) }
						</Text>
						<Text
							color={ 'var(--quizpress-warn-muted)' }
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __( '0, Means no time limit.', 'quizpress' ) }
						</Text>
					</Flex>
					<Flex
						alignItems="center"
						className="quizpress-quiz-settings__seconds"
						position="relative"
					>
						<Field
							type="number"
							name="meta.quizpress_quiz_time"
							className="quizpress-form-control"
							min="0"
							style={ { width: '134px' } }
						/>

						<Box position="relative" width="100%">
							<Field
								as="select"
								name="meta.quizpress_quiz_time_unit"
								onFocus={ ( e ) =>
									( e.target.style.boxShadow = 'none' )
								}
								style={ {
									appearance: 'none',
									background: 'var(--quizpress-gray)',
									padding: '0 32px 0 22px',
									lineHeight: '38px',
									border: '1px solid var(--quizpress-border-color)',
									borderLeft: 0,
									borderRadius: '0 4px 4px 0',
									width: '100%',
									cursor: 'pointer',
									margin: 0,
								} }
							>
								<option value="seconds">
									{ __( 'Sec', 'quizpress' ) }
								</option>
								<option value="minutes">
									{ __( 'Min', 'quizpress' ) }
								</option>
								<option value="hours">
									{ __( 'Hrs', 'quizpress' ) }
								</option>
							</Field>

							<Box
								position="absolute"
								right="10px"
								top="50%"
								transform="translateY(-50%)"
								pointerEvents="none"
							>
								<svg
									xmlns="http://www.w3.org/2000/svg"
									width="10"
									height="6"
									viewBox="0 0 10 6"
									fill="none"
								>
									<path
										d="M8.52827 0.529247C8.78862 0.268897 9.21063 0.268897 9.47098 0.529247C9.73133 0.789596 9.73133 1.21161 9.47098 1.47195L5.47098 5.47196C5.21063 5.7323 4.78862 5.7323 4.52827 5.47196L0.52827 1.47195C0.26792 1.21161 0.26792 0.789596 0.52827 0.529247C0.788619 0.268897 1.21063 0.268897 1.47098 0.529247L4.99962 4.05789L8.52827 0.529247Z"
										fill="#141A24"
									/>
								</svg>
							</Box>
						</Box>
					</Flex>
				</Flex>

				<Flex
					as="label"
					gap="8px"
					width="100%"
					justifyContent="space-between"
				>
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __( 'Questions order', 'quizpress' ) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __( 'Question order type', 'quizpress' ) }
						</Text>
					</Flex>
					<Box minWidth="240px">
						<Field
							as={ Select }
							name="meta.quizpress_quiz_questions_order"
							placeholder={ __( 'Quiz', 'quizpress' ) }
							options={ questionOrderOptions }
							value={ questionOrderOptions.find(
								( item ) =>
									item.value ===
									values?.meta.quizpress_quiz_questions_order
							) }
							onChange={ ( option ) => {
								setFieldValue(
									'meta.quizpress_quiz_questions_order',
									option ? option.value : ''
								);
							} }
							className="quizpress-select"
							classNamePrefix="quizpress-select"
						/>
					</Box>
				</Flex>

				<Flex
					paddingTop={ 6 }
					borderTop="1px solid var(--quizpress-border-color)"
					justifyContent="space-between"
					width="100%"
				>
					<Flex flexDirection="column" gap="8px">
						<Text className="quizpress-title" margin={ 0 }>
							{ __( 'Passing Grade (%)', 'quizpress' ) }
						</Text>
						<Text
							color={ 'var(--quizpress-warn-muted)' }
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __(
								'Set the passing percentage for this quiz.',
								'quizpress'
							) }
						</Text>
					</Flex>
					<Flex
						className="quizpress-quiz-settings__percentage"
						alignItems="center"
					>
						<Field
							// id="meta.quizpress_quiz_passing_grade"
							type="number"
							name="meta.quizpress_quiz_passing_grade"
							className="quizpress-form-control"
							min="0"
						/>
						<Box
							background="var(--quizpress-gray)"
							minW="7px"
							padding="0px 22px"
							lineHeight="38px"
							borderRadius="0 4px 4px 0"
							borderWidth="1px 1px 1px 0"
							display="flex"
							alignItems="center"
							justifyContent="space-around"
						>
							{ __( '%', 'quizpress' ) }
						</Box>
					</Flex>
				</Flex>

				<Flex as="label" gap="8px" width="100%" flexDirection="column">
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __( 'Quiz Feedback Mode', 'quizpress' ) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __(
								'( Pick the quiz system’s behavior on choice based questions.)',
								'quizpress'
							) }
						</Text>
					</Flex>

					{ isShowScoreSettings && (
						<Flex>
							<RadioCard.Root
								width={ '100%' }
								name="meta.quizpress_quiz_feedback_mode"
								defaultValue={
									values?.meta.quizpress_quiz_feedback_mode
								}
								onValueChange={ ( option ) => {
									setFieldValue(
										'meta.quizpress_quiz_feedback_mode',
										option.value
									);
								} }
							>
								<Flex gap={ 3 } alignItems="flex-end">
									{ radioItems.map( ( item ) => (
										<RadioCard.Item
											key={ item.value }
											value={ item.value }
											className="quizpress-radio__item"
										>
											<RadioCard.ItemHiddenInput />
											<RadioCard.ItemControl
												alignItems="center"
												className="quizpress-radio__control"
											>
												<RadioCard.ItemIndicator />
												<RadioCard.ItemText>
													<Text
														margin={ 0 }
														className="quizpress-title"
													>
														{ item.title }
													</Text>
													<Text
														margin={ 0 }
														className="quizpress-sub-title quizpress-radio__subtitle"
													>
														{ item.subtitle }
													</Text>{ ' ' }
												</RadioCard.ItemText>{ ' ' }
											</RadioCard.ItemControl>{ ' ' }
										</RadioCard.Item>
									) ) }{ ' ' }
								</Flex>
							</RadioCard.Root>
						</Flex>
					) }
				</Flex>

				{ values?.meta.quizpress_quiz_feedback_mode === 'retry_mode' &&
					isShowScoreSettings && (
						<>
							<Flex
								as="label"
								gap="8px"
								width="100%"
								justifyContent="space-between"
							>
								<Flex flexDirection="column" gap="4px">
									<Text className="quizpress-title">
										{ __(
											'Max Attempted Allowed',
											'quizpress'
										) }
									</Text>
									<Text
										color="var(--quizpress-warn-muted)"
										margin={ 0 }
										fontSize="0.75rem"
									>
										{ __(
											'Set how many attempts a user is allowed',
											'quizpress'
										) }
									</Text>
								</Flex>
								<Box className="quizpress-min-w--240">
									<Field
										as={ Input }
										type="number"
										name="meta.quizpress_quiz_max_attempts_allowed"
										placeholder={ __( '10', 'quizpress' ) }
									/>
								</Box>
							</Flex>

							<Flex
								as="label"
								gap="8px"
								width="100%"
								justifyContent="space-between"
							>
								<Flex flexDirection="column" gap="4px">
									<Text className="quizpress-title">
										{ __(
											'Allow Re-Attempt After Pass',
											'quizpress'
										) }
									</Text>
									<Text
										color="var(--quizpress-warn-muted)"
										margin={ 0 }
										fontSize="0.75rem"
									>
										{ __(
											'Allow users to re-attempt the quiz after passing.',
											'quizpress'
										) }
									</Text>
								</Flex>
								<CustomSwitch
									name="meta.quizpress_quiz_pass_reattempt"
									value={
										values?.meta
											.quizpress_quiz_pass_reattempt
									}
									onChange={ ( e ) =>
										setFieldValue(
											'meta.quizpress_quiz_pass_reattempt',
											e.target.checked
										)
									}
								/>
							</Flex>
						</>
					) }

				<Flex
					as="label"
					gap="8px"
					width="100%"
					justifyContent="space-between"
				>
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __(
								'Max Question Allowed to Answer',
								'quizpress'
							) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __(
								'Choose how many questions a user can answer; 0 allows unlimited.',
								'quizpress'
							) }
						</Text>
					</Flex>
					<Box className="quizpress-min-w--240">
						<Field
							as={ Input }
							className="quizpress-input"
							type="number"
							name="meta.quizpress_quiz_max_questions_for_answer"
							placeholder={ __( '10', 'quizpress' ) }
						/>
					</Box>
				</Flex>

				<Flex
					as="label"
					gap="8px"
					width="100%"
					justifyContent="space-between"
				>
					<Flex flexDirection="column" gap="4px">
						<Text className="quizpress-title">
							{ __( 'Hint Text', 'quizpress' ) }
						</Text>
						<Text
							color="var(--quizpress-warn-muted)"
							margin={ 0 }
							fontSize="0.75rem"
						>
							{ __(
								'Guide Your Participants with Helpful Prompts',
								'quizpress'
							) }
						</Text>
					</Flex>
					<Box className="quizpress-min-w--240">
						<Field
							as={ Textarea }
							className="quizpress-textarea"
							name="meta.quizpress_quiz_hint_text"
							placeholder={ __( 'Text here..', 'quizpress' ) }
						/>
					</Box>
				</Flex>
			</Flex>
		</Flex>
	);
};

export default ThirdStep;
