import React, { useState } from 'react';
import { __, sprintf } from '@wordpress/i18n';
import { Button, Flex, Input, Text, Span } from '@chakra-ui/react';
import { Field, useFormikContext } from 'formik';
import { generateSlug } from '@QPUtils/helper';
import Select from 'react-select';
import BlockEditor from '@QPComponents/BlockEditor';

const options = [
	{ label: __( 'Quiz', 'quizpress' ), value: 'quiz' },
	{
		label: __( 'Survey (Coming Soon)', 'quizpress' ),
		value: 'survey',
		isDisabled: true,
	},
	{
		label: __( 'Poll (Coming Soon)', 'quizpress' ),
		value: 'poll',
		isDisabled: true,
	},
	{ label: __( 'Exams', 'quizpress' ), value: 'exams' },
];

const LeftSection = () => {
	const { values, setFieldValue } = useFormikContext();
	const [ showDescription, isShowDescription ] = useState(
		Boolean( values?.content ) ?? false
	);

	return (
		<Flex
			width="65%"
			direction="column"
			bg="var(--quizpress-background)"
			p={ 6 }
			borderRadius="4px"
			boxShadow="var(--quizpress-shadow)"
			gap={ 4 }
			height="fit-content"
		>
			<Text as="h1" margin={ '0px' } className="quizpress-heading">
				{ values?.id
					? sprintf( __( '%s', 'quizpress' ), values.title )
					: __( 'Add Name', 'quizpress' ) }
			</Text>

			<Flex direction="column" gap="12px" width="100%">
				<Flex as="label" direction="column" gap="8px" width="100%">
					<Text className="quizpress-title quizpress-title-required">
						<Span>{ __( 'Name', 'quizpress' ) }</Span>
						<Span className="quizpress-title-required--sign">
							{ __( '*', 'quizpress' ) }
						</Span>
					</Text>
					<Field
						as={ Input }
						name="title"
						placeholder={ __( 'Enter name', 'quizpress' ) }
						className="quizpress-input"
						onBlur={ ( e ) =>
							setFieldValue(
								'slug',
								generateSlug( e.target.value )
							)
						}
					/>
				</Flex>
				{ ! showDescription ? (
					<Text
						cursor="pointer"
						onClick={ () => isShowDescription( true ) }
						color="blue.500"
						p={ 0 }
						fontWeight="500"
						fontSize="0.875rem"
						justifyContent="left"
						margin={ 0 }
					>
						{ __( '+ Add Description', 'quizpress' ) }
					</Text>
				) : (
					<Flex direction="column" gap="8px" width="100%">
						<Flex justifyContent="space-between">
							<Text className="quizpress-title">
								{ __( 'Description', 'quizpress' ) }
							</Text>
							<Button
								onClick={ () => isShowDescription( false ) }
								padding="0px 16px !important"
								height="26px"
								variant="ghost"
							>
								{ __( 'Close', 'quizpress' ) }
							</Button>
						</Flex>
						<BlockEditor
							name="content"
							defaultValue={ values?.content }
							saveValueHandler={ setFieldValue }
						/>
					</Flex>
				) }
				<Flex as="label" direction="column" gap="8px" width="100%">
					<Text className="quizpress-title quizpress-title-required">
						<Span>
							{ __(
								'What Would You Like to Create Today?',
								'quizpress'
							) }
						</Span>
						<Span className="quizpress-title-required--sign">
							{ __( '*', 'quizpress' ) }
						</Span>
					</Text>
					<Field
						as={ Select }
						name="type"
						placeholder={ __( 'Quiz', 'quizpress' ) }
						options={ options }
						value={ options.find(
							( item ) =>
								item.value === values.meta.quizpress_quiz_type
						) }
						onChange={ ( option ) => {
							setFieldValue(
								'meta.quizpress_quiz_type',
								option.value
							);
							//do something
						} }
						className="quizpress-select"
						classNamePrefix="quizpress-select"
					/>
				</Flex>
			</Flex>
		</Flex>
	);
};

export default LeftSection;
