import React, { useEffect, useState } from 'react';
import { __, sprintf } from '@wordpress/i18n';
import { Button, Flex, Span } from '@chakra-ui/react';
import { Text } from '@chakra-ui/react';
import { useFormikContext } from 'formik';
import { Box } from '@chakra-ui/react';
import {
	primaryBtn,
	removeBtn,
} from '../../../../../../../../assets/scss/chakra/recipe';
import { admin_url, API, runUploader, useQuery } from '@QPUtils/helper';
import { useSelector } from 'react-redux';

const RightSection = () => {
	const quizzes = useSelector( ( state ) => state.quizzes );
	const { values, setFieldValue } = useFormikContext();
	const [ attachment, setAttachment ] = useState( {} );
	const [ hovered, setHovered ] = useState( false );

	const location = useQuery();
	const quizId = Number( location.get( 'id' ) );

	const currentQuiz = quizzes.data.find(
		( quiz ) => Number( quiz.id ) === Number( quizId )
	);
	const isPaidQuiz =
		currentQuiz?.meta?.quizpress_quiz_product_type === 'paid';
	const productId = Number( currentQuiz?.meta?.quizpress_quiz_product_id );
	const regularPrice = currentQuiz?.meta?.quizpress_quiz_regular_price ?? 0;
	const salePrice = currentQuiz?.meta?.quizpress_quiz_sale_price ?? 0;
	const currency = currentQuiz?.meta?.quizpress_quiz_product_currency ?? '$';

	useEffect( () => {
		if ( values.featured_media ) {
			API.get( `wp/v2/media/${ values.featured_media }` ).then(
				( res ) => {
					setAttachment( { url: res.data.source_url } );
				}
			);
		} else {
			setAttachment( {} );
		}
	}, [ values ] );

	const uploadImageHandler = ( e ) => {
		e.preventDefault();
		runUploader().then( ( res ) => {
			setFieldValue( 'featured_media', res.id );
			setAttachment( res );
		} );
	};

	const removeFeaturedImage = () => {
		setFieldValue( 'featured_media', 0 );
		setAttachment( {} );
	};
	return (
		<React.Fragment>
			<Flex direction="column" width="30%" gap={ 4 }>
				<Flex
					width="100%"
					p={ 6 }
					borderRadius="4px"
					boxShadow="var(--quizpress-shadow)"
					direction="column"
					height="fit-content"
					bg="var(--quizpress-background)"
				>
					<Text className="quizpress-heading">
						{ __( 'Featured Image', 'quizpress' ) }
					</Text>

					{ Object.keys( attachment ).length > 0 && (
						<Box
							position="relative"
							display="inline-block"
							marginBottom="12px"
							onMouseEnter={ () => setHovered( true ) }
							onMouseLeave={ () => setHovered( false ) }
							_before={ {
								content: '""',
								position: 'absolute',
								top: 0,
								left: 0,
								width: '100%',
								height: '100%',
								backgroundColor: 'rgba(0, 0, 0, 0.4)',
								borderRadius: '4px',
								opacity: hovered ? 1 : 0,
								transition: 'opacity 0.3s ease',
								zIndex: 1,
							} }
						>
							<img
								src={ attachment.url }
								alt={ __( 'Featured Image', 'quizpress' ) }
								aria-hidden="true"
								style={ {
									width: '100%',
									height: 'auto',
									borderRadius: '4px',
									display: 'block',
								} }
							/>

							<Button
								type="button"
								className="quizpress-feature-image__remove-btn"
								position="absolute"
								bottom="8px"
								right="8px"
								zIndex="2"
								transition="opacity 0.3s ease"
								opacity={ hovered ? 1 : 0 }
								onClick={ removeFeaturedImage }
								{ ...removeBtn }
							>
								<span className="quizpress-icon quizpress-icon--trash has-quizpress-blue-bg" />
							</Button>
						</Box>
					) }

					<Button
						type="button"
						onClick={ ( e ) => uploadImageHandler( e ) }
						{ ...primaryBtn }
					>
						{ Object.keys( attachment ).length > 0
							? __( 'Replace Image', 'quizpress' )
							: __( 'Add Featured Image', 'quizpress' ) }
					</Button>
				</Flex>

				{ isPaidQuiz && (
					<Flex
						width="100%"
						p={ 6 }
						borderRadius="4px"
						boxShadow="var(--quizpress-shadow)"
						direction="column"
						height="fit-content"
						bg="var(--quizpress-background)"
						gap={ 3 }
					>
						<Text m={ 0 } fontSize="1rem">
							<Span fontWeight={ 600 }>
								{ __( 'Type:', 'quizpress' ) }
							</Span>
							{ __( 'paid', 'quizpress' ) }
						</Text>

						<Text m={ 0 } fontSize="1rem">
							<Span fontWeight={ 600 }>
								{ __( 'Regular Price:', 'quizpress' ) }
							</Span>
							{ sprintf(
								__( '%s%s', 'quizpress' ),
								currency.trim(),
								regularPrice
							) }
						</Text>
						<Text m={ 0 } fontSize="1rem">
							<Span fontWeight={ 600 }>
								{ __( 'Sale Price:', 'quizpress' ) }
							</Span>
							{ sprintf(
								__( '%s%s', 'quizpress' ),
								currency.trim(),
								salePrice
							) }
						</Text>

						<Text m={ 0 }>
							{ __( 'To update the quiz price', 'quizpress' ) }
							<Button
								as="a"
								target="_blank"
								rel="noopener noreferrer"
								href={ `${ admin_url }post.php?post=${ productId }&action=edit` }
								bg="transparent"
								border="none"
								color="var(--quizpress-primary)"
								textDecoration="underline"
								_hover={ {
									textDecoration: 'none',
								} }
								padding={ 0 }
								height={ 0 }
							>
								{ __( 'click here', 'quizpress' ) }
							</Button>
						</Text>
					</Flex>
				) }
			</Flex>
		</React.Fragment>
	);
};

export default RightSection;
