import React, { useState } from 'react';
import { __ } from '@wordpress/i18n';
import ReactModalFormik from '@QPComponents/Modal/ReactModalFormik';
import {
	Button,
	CloseButton,
	FileUpload,
	Flex,
	HStack,
	Input,
	InputGroup,
	RadioGroup,
	Span,
	Text,
} from '@chakra-ui/react';
import { useFormikContext } from 'formik';
import { primaryBtn } from '../../../../../../../../assets/scss/chakra/recipe';

export default function QuestionImportExport( {
	isOpen,
	onClose,
	handleSubmit,
} ) {
	const [ type, setType ] = useState( 'import' );

	return (
		<ReactModalFormik
			isOpen={ isOpen }
			onRequestClose={ onClose }
			submitButtonLabel={
				type === 'import'
					? __( 'Import', 'quizpress' )
					: __( 'Export', 'quizpress' )
			}
			title={ __( 'Import/Export Questions', 'quizpress' ) }
			isEnabledFooter={ true }
			isEnabledResizer={ false }
			size="small"
			formik={ {
				enableReinitialize: true,
				initialValues: {
					upload_file: null,
					type: 'import',
				},
				onSubmit: handleSubmit,
			} }
		>
			<FormInner setType={ setType } />
		</ReactModalFormik>
	);
}

function FormInner( { setType } ) {
	const { values, setFieldValue } = useFormikContext();
	return (
		<Flex direction="column" gap={ 4 }>
			<Flex gap={ 3 } alignItems="center">
				<RadioGroup.Root
					value={ values.type }
					onValueChange={ ( e ) => {
						setFieldValue( 'type', e.value );
						setType( e.value );
					} }
					className="quizpress-radio"
				>
					<HStack gap="6">
						<RadioGroup.Item
							value="import"
							className="quizpress-radio__item"
						>
							<RadioGroup.ItemHiddenInput />
							<RadioGroup.ItemIndicator className="quizpress-radio__indicator" />
							<RadioGroup.ItemText>
								{ __( 'Import', 'quizpress' ) }
							</RadioGroup.ItemText>
						</RadioGroup.Item>
						<RadioGroup.Item
							value="export"
							className="quizpress-radio__item"
						>
							<RadioGroup.ItemHiddenInput />
							<RadioGroup.ItemIndicator className="quizpress-radio__indicator" />
							<RadioGroup.ItemText>
								{ __( 'Export', 'quizpress' ) }
							</RadioGroup.ItemText>
						</RadioGroup.Item>
					</HStack>
				</RadioGroup.Root>
			</Flex>

			{ values.type === 'import' ? (
				<Flex direction="column" gap={ 3 }>
					<Text className="quizpress-title quizpress-title-required">
						{ __( 'Select a CSV file', 'quizpress' ) }
						<Span className="quizpress-title-required--sign">
							*
						</Span>
					</Text>

					<FileUpload.Root
						maxW="xl"
						alignItems="stretch"
						maxFiles={ 1 }
						allowDrop={ true }
						preventDocumentDrop={ false }
						accept={ [ '.csv', 'text/csv' ] }
						name="  "
						required={ true }
						onFileChange={ ( e ) => {
							setFieldValue(
								'upload_file',
								e.acceptedFiles[ 0 ]
							);
						} }
						onFileReject={ ( e ) => {
							setFieldValue( 'upload_file', null );
						} }
					>
						<FileUpload.HiddenInput />
						<InputGroup
							endElement={
								<FileUpload.ClearTrigger asChild>
									<CloseButton
										me="-1"
										size="xs"
										variant="plain"
										focusVisibleRing="inside"
										focusRingWidth="2px"
										pointerEvents="auto"
									/>
								</FileUpload.ClearTrigger>
							}
						>
							<Input asChild>
								<FileUpload.Trigger>
									<FileUpload.FileText lineClamp={ 1 } />
								</FileUpload.Trigger>
							</Input>
						</InputGroup>
					</FileUpload.Root>
				</Flex>
			) : (
				<Flex gap={ 3 } alignItems="center">
					<Button { ...primaryBtn }>
						{ __( 'Download Demo', 'quizpress' ) }
					</Button>
					<Button
						as="a"
						_target="_blank"
						href="#"
						bg="transparent"
						border="none"
						color="var(--quizpress-primary)"
						textDecoration="underline"
						_hover={ {
							textDecoration: 'none',
						} }
						padding={ 0 }
					>
						{ __( 'Read Docs', 'quizpress' ) }
					</Button>
				</Flex>
			) }
		</Flex>
	);
}
