import {
	Button,
	Flex,
	SwitchControl,
	SwitchHiddenInput,
	SwitchLabel,
	SwitchRoot,
	Text,
} from '@chakra-ui/react';
import { __ } from '@wordpress/i18n';
import { useFormikContext } from 'formik';
import React from 'react';

export const CustomField = () => {
	const { values, setFieldValue, handleSubmit, dirty, isSubmitting } =
		useFormikContext();

	return (
		<div className="quizpress-page-content--settings">
			<Flex
				width="100%"
				direction="column"
				bg="var(--quizpress-background)"
				p={ 6 }
				borderRadius="4px"
				boxShadow="var(--quizpress-shadow)"
				gap={ 4 }
			>
				<h1 className="quizpress-heading">
					{ __( 'Custom Field', 'quizpress' ) }
				</h1>

				<Flex
					width="100%"
					direction="column"
					bg="var(--quizpress-background)"
					p={ 6 }
					borderRadius="4px"
					boxShadow="var(--quizpress-shadow)"
					gap={ 4 }
				>
					<Flex
						justifyContent="space-between"
						alignItems="center"
						width="100%"
					>
						<Flex direction="column">
							<Text
								fontSize="1rem"
								fontWeight="semibold"
								margin={ '0' }
							>
								{ __( 'Additional Field', 'quizpress' ) }
							</Text>
							<Text
								fontSize="0.75rem"
								color="var(--quizpress-secondary)"
								margin={ '0' }
							>
								{ __(
									'Collect specific details from Quiz.',
									'quizpress'
								) }
							</Text>
						</Flex>

						{ /* Switch */ }
						<SwitchRoot
							defaultChecked={ values.enable_additional_field }
							onCheckedChange={ ( checked ) =>
								setFieldValue(
									'enable_additional_field',
									checked
								)
							}
						>
							<SwitchHiddenInput />
							<SwitchControl
								_checked={ { bg: 'var(--quizpress-primary)' } }
								borderRadius="full"
							/>
						</SwitchRoot>
					</Flex>

					<Flex gap="0.75rem">
						<Button
							color="var(--quizpress-primary)"
							background="transparent"
							border="1px solid var(--quizpress-primary)"
						>
							<span className="quizpress-icon quizpress-icon--settings" />
							{ __( 'Add Custom Field', 'quizpress' ) }
						</Button>
					</Flex>
					<Flex
						justifyContent="flex-end"
						borderTop="1px solid var(--quizpress-border-color)"
						gap="12px"
						paddingTop="12px"
					>
						<Button
							color="#fff"
							background="var(--quizpress-primary)"
							onClick={ handleSubmit }
							disabled={ ! dirty || isSubmitting }
							loading={ isSubmitting }
						>
							{ __( 'Save Changes', 'quizpres' ) }
						</Button>
					</Flex>
				</Flex>
			</Flex>
		</div>
	);
};
