import {
	Button,
	Flex,
	SwitchControl,
	SwitchHiddenInput,
	SwitchLabel,
	SwitchRoot,
	Text,
} from '@chakra-ui/react';
import { __ } from '@wordpress/i18n';
import { useFormikContext } from 'formik';
import React, { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';

export const DetailedReport = () => {
	const { values, setFieldValue, isSubmitting, dirty, handleSubmit } =
		useFormikContext();
	const [ loading, isLoading ] = useState( false );
	const settings = useSelector( ( state ) => state.settings );

	const userInformation = [
		{
			value: 'quizpress_user_service_details.is_show_user_ip',
			label: __( 'Show User IP', 'quizpress' ),
			defaultValue:
				values?.quizpress_user_service_details?.is_show_user_ip,
		},
		{
			value: 'quizpress_user_service_details.is_show_user_id',
			label: __( 'Show User ID', 'quizpress' ),
			defaultValue:
				values?.quizpress_user_service_details?.is_show_user_id,
		},
		{
			value: 'quizpress_user_service_details.is_show_user_email',
			label: __( 'Show User Email', 'quizpress' ),
			defaultValue:
				values?.quizpress_user_service_details?.is_show_user_email,
		},
		{
			value: 'quizpress_user_service_details.is_show_user_name',
			label: __( 'Show User Name', 'quizpress' ),
			defaultValue:
				values?.quizpress_user_service_details?.is_show_user_name,
		},
		{
			value: 'quizpress_user_service_details.is_show_user',
			label: __( 'Show User', 'quizpress' ),
			defaultValue: values?.quizpress_user_service_details?.is_show_user,
		},
	];

	const QuizInformation = [
		{
			value: 'quizpress_user_service_details.is_show_start_date',
			label: __( 'Show Start Date', 'quizpress' ),
			defaultValue:
				values?.quizpress_user_service_details?.is_show_start_date,
		},
		{
			value: 'quizpress_user_service_details.is_show_duration',
			label: __( 'Show Duration', 'quizpress' ),
			defaultValue:
				values?.quizpress_user_service_details?.is_show_duration,
		},
		{
			value: 'quizpress_user_service_details.is_show_score',
			label: __( 'Show Score', 'quizpress' ),
			defaultValue: values?.quizpress_user_service_details?.is_show_score,
		},
		{
			value: 'quizpress_user_service_details.is_show_rating',
			label: __( 'Show Rating', 'quizpress' ),
			defaultValue:
				values?.quizpress_user_service_details?.is_show_rating,
		},
	];

	useEffect( () => {
		if ( ! settings.data ) {
			isLoading( true );
		} else {
			isLoading( false );
		}
	}, [ settings.data ] );

	return (
		<>
			{ loading ? (
				<h1>Loading</h1>
			) : (
				<div className="quizpress-page-content--settings">
					<Flex
						width="100%"
						direction="column"
						bg="var(--quizpress-background)"
						p={ 6 }
						borderRadius="4px"
						boxShadow="var(--quizpress-shadow)"
						gap={ 4 }
					>
						<Text
							as={ 'h1' }
							margin={ 0 }
							className="quizpress-heading"
						>
							{ __( 'Detailed Report', 'quizpress' ) }
						</Text>
						<Text
							as={ 'h1' }
							margin={ 0 }
							className="quizpress-heading"
						>
							{ __( 'User Information', 'quizpress' ) }
						</Text>
						{ userInformation.map( ( info ) => (
							<SwitchRoot
								onCheckedChange={ ( e ) =>
									setFieldValue( info.value, e.checked )
								}
								defaultChecked={ info.defaultValue }
								justifyContent={ 'space-between' }
							>
								<SwitchLabel>{ info.label }</SwitchLabel>
								<SwitchHiddenInput />
								<SwitchControl
									_checked={ {
										bg: 'var(--quizpress-primary)',
									} }
									borderRadius="full"
								/>
							</SwitchRoot>
						) ) }
						{ /* quiz information */ }
						<Text
							as={ 'h1' }
							margin={ 0 }
							className="quizpress-heading"
						>
							{ __( 'Quiz Information', 'quizpress' ) }
						</Text>
						{ QuizInformation.map( ( info ) => (
							<SwitchRoot
								onCheckedChange={ ( e ) =>
									setFieldValue( info.value, e.checked )
								}
								defaultChecked={ info.defaultValue }
								justifyContent={ 'space-between' }
							>
								<SwitchLabel>{ info.label }</SwitchLabel>
								<SwitchHiddenInput />
								<SwitchControl
									_checked={ {
										bg: 'var(--quizpress-primary)',
									} }
									borderRadius="full"
								/>
							</SwitchRoot>
						) ) }
						<Flex
							justifyContent="flex-end"
							borderTop="1px solid var(--quizpress-border-color)"
							gap="12px"
							paddingTop="12px"
						>
							<Button
								color="#fff"
								background="var(--quizpress-primary)"
								onClick={ handleSubmit }
								disabled={ ! dirty || isSubmitting }
								loading={ isSubmitting }
							>
								{ __( 'Save Changes', 'quizpres' ) }
							</Button>
						</Flex>
					</Flex>
				</div>
			) }
		</>
	);
};
