import { __ } from '@wordpress/i18n';
import {
	Flex,
	Input,
	SwitchRoot,
	SwitchLabel,
	SwitchHiddenInput,
	SwitchControl,
	Text,
	Button,
	Span,
} from '@chakra-ui/react';
import Select from 'react-select';
import React, { useEffect, useState } from 'react';
import { Field, useFormikContext } from 'formik';
import { useSelector } from 'react-redux';
import { questionTypeOptions } from '@QPUtils/helper';
import Preloader from '@QPComponents/Loader/Preloader';

export const General = () => {
	const { setFieldValue, handleSubmit, isSubmitting, dirty, values } =
		useFormikContext();
	const [ loading, isLoading ] = useState( false );
	const settings = useSelector( ( state ) => state.settings );

	const fieldsSwitch = [
		{
			label: __( 'Does not store IP address', 'quizpress' ),
			value: 'is_disable_store_ip_address',
			defaultValue: values?.is_disable_store_ip_address,
		},
	];

	useEffect( () => {
		if ( ! settings.data ) {
			isLoading( true );
		} else {
			isLoading( false );
		}
	}, [ settings.data ] );

	return (
		<>
			{ loading ? (
				<Preloader />
			) : (
				<div className="quizpress-page-content--settings">
					<Flex
						width="100%"
						direction="column"
						bg="var(--quizpress-background)"
						p={ 6 }
						borderRadius="4px"
						boxShadow="var(--quizpress-shadow)"
						gap={ 6 }
					>
						<Flex
							as="label"
							gap={ 6 }
							width="70%"
							alignItems="center"
						>
							<Text width="70%" className="quizpress-title">
								{ __( 'Questions default type', 'quizpress' ) }
							</Text>
							<Select
								placeholder={ __(
									'Select question type',
									'quizpress'
								) }
								className="quizpress-select--w-full"
								classNamePrefix="quizpress-select"
								options={ questionTypeOptions }
								value={
									// Use flatMap to handle grouped select options correctly
									questionTypeOptions
										.flatMap( ( group ) => group.options )
										.find(
											( opt ) =>
												opt.value ===
												values.quizpress_questions_default_type
										) || null
								}
								onChange={ ( opt ) =>
									setFieldValue(
										'quizpress_questions_default_type',
										opt.value
									)
								}
							/>
						</Flex>

						<Flex
							as="label"
							gap={ 6 }
							width="70%"
							alignItems="center"
						>
							<Text width="72%" className="quizpress-title">
								{ __(
									'Textarea Height (public)',
									'quizpress'
								) }
							</Text>
							<Field
								as={ Input }
								name="quizpress_public_textarea_height"
								className="quizpress-input "
								type="number"
								placeholder={ __( '200', 'quizpress' ) }
								value={
									values.quizpress_public_textarea_height
								}
							/>
						</Flex>

						<Flex
							as="label"
							gap={ 6 }
							width="70%"
							alignItems="center"
						>
							<Text width="40%" className="quizpress-title">
								{ __( 'Question Title View', 'quizpress' ) }
							</Text>
							<Flex>
								<Flex as="label" alignItems="center" gap={ 1 }>
									<Field
										style={ { marginTop: '0px' } }
										type="radio"
										name="quizpress_question_title_view"
										value="question_content"
										checked={
											values.quizpress_question_title_view ===
											'question_content'
										}
									/>
									<Span fontWeight="400" fontSize="0.875rem">
										{ __(
											'By Question Content',
											'quizpress'
										) }
									</Span>
								</Flex>
								<label style={ { marginLeft: '12px' } }>
									<Field
										style={ { marginTop: '0px' } }
										type="radio"
										name="quizpress_question_title_view"
										value="question_title"
										checked={
											values.quizpress_question_title_view ===
											'question_title'
										}
									/>
									<Span fontWeight="400" fontSize="0.875rem">
										{ __(
											'By Question Title',
											'quizpress'
										) }
									</Span>
								</label>
							</Flex>
						</Flex>

						<Flex gap={ 6 } width="70%" alignItems="center">
							{ fieldsSwitch.map( ( item, index ) => (
								<SwitchRoot
									key={ index }
									defaultChecked={ item.defaultValue }
									onCheckedChange={ ( e ) =>
										setFieldValue( item.value, e.checked )
									}
									display="flex"
									justifyContent="space-between"
									gap="1.5rem"
									width="48.5%"
								>
									<SwitchLabel className="quizpress-title">
										{ item.label }
									</SwitchLabel>
									<SwitchHiddenInput />
									<SwitchControl
										_checked={ {
											bg: 'var(--quizpress-primary)',
										} }
									/>
								</SwitchRoot>
							) ) }
						</Flex>

						<Flex
							as="label"
							gap={ 6 }
							width="70%"
							alignItems="center"
						>
							<Text width="72%" className="quizpress-title">
								{ __( 'Erase Quiz Data (Month)', 'quizpress' ) }
							</Text>
							<Field
								as={ Input }
								className="quizpress-input"
								name="quizpress_quiz_data_erase"
								type="number"
								placeholder={ __( '2', 'quizpress' ) }
								value={ values.quizpress_quiz_data_erase }
							/>
						</Flex>

						{ /* <Flex as="label" gap={6} width="70%" alignItems="center">
							<Text
								width="72%"
								className='quizpress-title'
							>
								{__(
									'Set Login URL',
									'quizpress'
								)}
							</Text>
							<Field
								as={Input}
								className="quizpress-input"
								name="quizpress_quiz_set_login_url"
								type="text"
								placeholder={__('https://example.com', 'quizpress')}
								value={values?.quizpress_quiz_set_login_url}
							/>
						</Flex> */ }
						<Flex
							justifyContent="flex-end"
							borderTop="1px solid #CBD1D7"
							gap="12px"
							paddingTop="12px"
						>
							<Button
								color="#fff"
								background="var(--quizpress-primary)"
								onClick={ handleSubmit }
								disabled={ ! dirty || isSubmitting }
								loading={ isSubmitting }
							>
								{ __( 'Save Changes', 'quizpres' ) }
							</Button>
						</Flex>
					</Flex>
				</div>
			) }
		</>
	);
};
