import {
	Button,
	Checkbox,
	CheckboxControl,
	CheckboxHiddenInput,
	CheckboxLabel,
	CheckboxRoot,
	Flex,
	Text,
} from '@chakra-ui/react';
import { __ } from '@wordpress/i18n';
import { useFormikContext } from 'formik';
import React, { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';

const roleOptions = [
	{ value: 'administrator', label: __( 'Administrator', 'quizpress' ) },
	{ value: 'editor', label: __( 'Editor', 'quizpress' ) },
	{ value: 'quiz_manager', label: __( 'Quiz Manager', 'quizpress' ) },
	{ value: 'author', label: __( 'Author', 'quizpress' ) },
];

export const RoleManagement = () => {
	const [ loading, isLoading ] = useState( false );
	const settings = useSelector( ( state ) => state.settings );
	const { values, setFieldValue, handleSubmit, dirty, isSubmitting } =
		useFormikContext();
	const roleAccess =
		values?.quizpress_quiz_role_management
			?.select_user_role_for_data_changes_access;

	useEffect( () => {
		if ( ! settings.data ) {
			isLoading( true );
		} else {
			isLoading( false );
		}
	}, [ settings.data ] );

	return (
		<>
			{ loading ? (
				<div>{ __( 'Loading', 'quizpress' ) }</div>
			) : (
				<div className="quizpress-page-content--settings">
					<Flex
						width="100%"
						direction="column"
						bg="var(--quizpress-background)"
						p={ 6 }
						borderRadius="4px"
						boxShadow="var(--quizpress-shadow)"
						gap={ 4 }
					>
						<Text
							as={ 'h1' }
							margin={ 0 }
							className="quizpress-heading"
						>
							{ __( 'Role Management', 'quizpress' ) }
						</Text>
						<Flex
							width="100%"
							direction="column"
							bg="var(--quizpress-background)"
							p={ 6 }
							borderRadius="4px"
							boxShadow="var(--quizpress-shadow)"
							gap={ 4 }
						>
							<Flex direction="column" gap={ 4 }>
								<Text m={ 0 } className="quizpress-title">
									{ __(
										'1. Select user role for giving access to Change all Quiz data',
										'quizpress'
									) }
								</Text>

								<Flex gap={ 6 } flexWrap="wrap">
									{ roleOptions.map( ( role ) => (
										<CheckboxRoot
											key={ role.value }
											defaultChecked={
												roleAccess?.[ role.value ] ??
												false
											}
											onCheckedChange={ ( e ) => {
												setFieldValue(
													`quizpress_quiz_role_management.select_user_role_for_data_changes_access.${ role.value }`,
													e.checked
												);
											} }
										>
											<CheckboxControl
												_checked={ {
													bg: 'var(--quizpress-primary)',
													borderColor:
														'var(--quizpress-primary)',
												} }
												borderRadius="4px"
											/>
											<CheckboxLabel m={ 0 }>
												{ role.label }
											</CheckboxLabel>
											<CheckboxHiddenInput />
										</CheckboxRoot>
									) ) }
								</Flex>
							</Flex>
							<Flex
								justifyContent="flex-end"
								borderTop="1px solid var(--quizpress-border-color)"
								gap="12px"
								paddingTop="12px"
							>
								<Button
									color="#fff"
									background="var(--quizpress-primary)"
									onClick={ handleSubmit }
									disabled={ ! dirty || isSubmitting }
									loading={ isSubmitting }
								>
									{ __( 'Save Changes', 'quizpres' ) }
								</Button>
							</Flex>
						</Flex>
					</Flex>
				</div>
			) }
		</>
	);
};
