export const getDefaultSettings = ( data = null ) => {
	if ( data && Object.keys( data ).length > 0 ) {
		return data.data;
	}
	return {
		quizpress_questions_default_type: 'true_false',
		quizpress_answer_default_count: 5,
		quizpress_questions_default_category: 'uncategorized',
		quizpress_wp_editor_height: 200,
		quizpress_public_textarea_height: 200,
		quizpress_question_title_view: 'question_content',
		is_enable_answers_allow_html_for_new_question: false,
		is_show_quiz_button_admins_only: false,
		is_enable_hide_question_text_for_new_question: false,
		is_enable_start_button_loader: false,
		is_disable_store_ip_address: false,
		enable_additional_field: false,
		quizpress_quiz_role_management: {
			select_user_role_for_data_changes_access: {
				administrator: true,
				author: false,
				editor: false,
				quiz_manager: true,
			},
		},
		quizpress_custom_field: [],
		quizpress_quiz_data_erase: 2,
		quizpress_user_service_details: {
			is_show_duration: true,
			is_show_rating: true,
			is_show_score: true,
			is_show_start_date: true,
			is_show_user: true,
			is_show_user_email: true,
			is_show_user_id: true,
			is_show_user_ip: true,
			is_show_user_name: true,
		},
	};
};
