import React, { useEffect } from 'react';
import { __ } from '@wordpress/i18n';
import {
	Box,
	Flex,
	Tabs,
	TabsContent,
	TabsIndicator,
	TabsList,
	TabsRoot,
	TabsTrigger,
	Text,
} from '@chakra-ui/react';
import { Formik } from 'formik';
import { useDispatch, useSelector } from 'react-redux';
import { CustomField } from './Tabs/CustomField';
import { DetailedReport } from './Tabs/DetailedReport';
import TopBar from '@QPComponents/TopBar';
import QPLabel from '@QPComponents/Labels/QPLabel';
import { General } from './Tabs/General';
import './Styles.scss';
import { RoleManagement } from './Tabs/RoleManagement';
import { useNavigate } from 'react-router-dom';
import { route_path, useQuery } from '@QPUtils/helper';
import { getDefaultSettings } from './helper';
import { updateSettings } from '@QPRedux/Slices/settingsSlice/settingsSlice';

const SettingArray = [
	{
		label: 'General Settings',
		value: 'general',
		component: <General />,
		icon: 'settings',
		subLabel: 'Basic Service Details',
	},
	// {
	//   label: "Custom Field",
	//   value: "custom_field", // Fixed typo: was "custom_filed"
	//   component: <CustomField />,
	//   icon: "custom-field",
	//   subLabel: "Extra Input Options",
	// },
	{
		label: 'Role Management',
		value: 'role_management',
		component: <RoleManagement />,
		icon: 'role-management',
		subLabel: 'User roles & access',
	},
	// {
	// 	label: 'Detailed Report',
	// 	value: 'detailed_report',
	// 	component: <DetailedReport />,
	// 	icon: 'role-management',
	// 	subLabel: 'Detailed reporting options',
	// },
];

const Settings = () => {
	const location = useQuery();
	const navigate = useNavigate();
	const dispatch = useDispatch();
	const currentPath = location.get( 'path' ) || 'general';
	const settings = useSelector( ( state ) => state.settings );

	const onSubmit = ( values, { setSubmitting, resetForm } ) => {
		setSubmitting( true );
		dispatch(
			updateSettings( {
				...values,
			} )
		).finally( () => {
			setSubmitting( false );
			resetForm( { values } );
		} );
	};

	const handleNavigate = ( tabPath ) => {
		navigate(
			`${ route_path }admin.php?page=quizpress-settings&path=${ tabPath }`
		);
	};

	return (
		<>
			<TopBar
				leftContent={ () => (
					<>
						<span className="quizpress-topbar-logo quizpress-icon quizpress-icon--quizpress" />
						<span className="quizpress-icon quizpress-icon--angle-right" />
						<QPLabel
							as="h2"
							color="#4F46E5"
							type="subtitle"
							fontWeight="medium"
							label={ __( `Settings`, 'quizpress' ) }
						/>
					</>
				) }
			/>
			<div className="quizpress-page-content">
				{ /* <TabsRoot
					value={ currentPath }
					variant="plain"
					orientation="vertical"
					display="flex"
					justifyContent="center"
					alignContent="center"
					gap="24px"
					maxWidth="1250px"
					margin="0 0 100px"
					padding="0 16px"
				>
					<TabsList
						bg="var(--quizpress-background)"
						height="fit-content"
						width="40%"
						borderRadius="4px"
						boxShadow="xs"
						padding="8px 16px"
						gap="1"
					>
						{ SettingArray.map( ( item, index ) => (
							<TabsTrigger
								key={ index }
								value={ item.value }
								width="auto"
								p="0"
								height="auto"
								transition="all 0.2s ease"
								_hover={ {
									bg: 'var(--quizpress-body-background)',
								} }
								_selected={ {
									bg: 'var(--quizpress-body-background)',
									borderRadius: '4px',
								} }
								alignItems="flex-start"
								alignSelf="stretch"
								onClick={ () => handleNavigate( item.value ) }
							>
								<Flex alignItems="flex-start" p="4" gap="2">
									<Flex pt="4px">
										<span
											className={ `quizpress-icon quizpress-icon--${ item.icon }` }
										/>
									</Flex>
									<Flex
										flexDirection="column"
										alignItems="flex-start"
									>
										<Text
											className='quizpress-title'
											margin="0"
											whiteSpace="nowrap"
											color="var(--quizpress-font-color)"
										>
											{ item.label }
										</Text>
										<Text
											fontSize="12px"
											lineHeight="16px"
											fontWeight="medium"
											margin="0"
											color="var(--quizpress-secondary)"
										>
											{ item.subLabel }
										</Text>
									</Flex>
								</Flex>
							</TabsTrigger>
						) ) }
						<TabsIndicator />
					</TabsList>

				</TabsRoot> */ }
				<Formik
					enableReinitialize={ true }
					initialValues={ getDefaultSettings( settings ) }
					onSubmit={ onSubmit }
				>
					{ () => (
						<>
							{ /* { SettingArray.map( ( item, index ) => (
									<TabsContent
										key={ index }
										value={ item.value }
										width="100%"
										height="100%"
										background="var(--quizpress-background)"
										padding="0"
										borderRadius="4px"
									>
										{ item.component }
									</TabsContent>
								) ) } */ }
							<General />
						</>
					) }
				</Formik>
			</div>
		</>
	);
};

export default Settings;
